/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.MaxGauge;
import com.netflix.servo.monitor.MinGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.StepCounter;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.Tags;
import java.util.List;

public class BasicDistributionSummary
extends AbstractMonitor<Long>
implements CompositeMonitor<Long> {
    private static final String STATISTIC = "statistic";
    private static final Tag STAT_TOTAL = Tags.newTag("statistic", "totalAmount");
    private static final Tag STAT_COUNT = Tags.newTag("statistic", "count");
    private static final Tag STAT_MAX = Tags.newTag("statistic", "max");
    private static final Tag STAT_MIN = Tags.newTag("statistic", "min");
    private final StepCounter totalAmount;
    private final StepCounter count;
    private final MaxGauge max;
    private final MinGauge min;
    private final List<Monitor<?>> monitors;

    public BasicDistributionSummary(MonitorConfig config) {
        super(config);
        this.totalAmount = new StepCounter(config.withAdditionalTag(STAT_TOTAL));
        this.count = new StepCounter(config.withAdditionalTag(STAT_COUNT));
        this.max = new MaxGauge(config.withAdditionalTag(STAT_MAX));
        this.min = new MinGauge(config.withAdditionalTag(STAT_MIN));
        this.monitors = ImmutableList.of((Object)this.totalAmount, (Object)this.count, (Object)this.max, (Object)this.min);
    }

    @Override
    public List<Monitor<?>> getMonitors() {
        return this.monitors;
    }

    public void record(long amount) {
        if (amount > 0L) {
            this.totalAmount.increment(amount);
            this.count.increment();
            this.max.update(amount);
            this.min.update(amount);
        }
    }

    @Override
    public Long getValue(int pollerIndex) {
        long cnt = this.count.getCurrentCount(pollerIndex);
        long total = this.totalAmount.getCurrentCount(pollerIndex);
        long value = (long)((double)total / (double)cnt);
        return cnt == 0L ? 0L : value;
    }

    public Long getTotalAmount() {
        return this.totalAmount.getCurrentCount(0);
    }

    public Long getCount() {
        return this.count.getCurrentCount(0);
    }

    public Long getMin() {
        return this.min.getCurrentValue(0);
    }

    public Long getMax() {
        return this.max.getCurrentValue(0);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("totalAmount", (Object)this.totalAmount).add("count", (Object)this.count).add("min", (Object)this.min).add("max", (Object)this.max).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.totalAmount, this.count, this.max, this.min});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof BasicDistributionSummary)) {
            return false;
        }
        BasicDistributionSummary m = (BasicDistributionSummary)obj;
        return this.config.equals(m.getConfig()) && this.totalAmount.equals(m.totalAmount) && this.count.equals(m.count) && this.max.equals(m.max) && this.min.equals(m.min);
    }
}

