/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Pollers;
import com.netflix.servo.monitor.StepLong;
import com.netflix.servo.util.Clock;
import java.util.concurrent.atomic.AtomicLong;

public class PeakRateCounter
extends AbstractMonitor<Number>
implements Counter {
    private final Clock clock;
    private final AtomicLong currentSecond = new AtomicLong();
    private final AtomicLong currentCount = new AtomicLong();
    private final StepLong peakRate;

    public PeakRateCounter(MonitorConfig config) {
        this(config, Clock.WALL);
    }

    PeakRateCounter(MonitorConfig config, Clock clock) {
        super(config.withAdditionalTag(DataSourceType.GAUGE));
        this.clock = clock;
        this.peakRate = new StepLong(0L, clock);
    }

    @Override
    public Number getValue(int pollerIdx) {
        return this.peakRate.getCurrent(pollerIdx);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof PeakRateCounter)) {
            return false;
        }
        PeakRateCounter c = (PeakRateCounter)obj;
        return this.config.equals(c.getConfig()) && this.getValue(0).doubleValue() == c.getValue(0).doubleValue();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.getValue(0).doubleValue()});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("max rate per second", this.getValue()).toString();
    }

    @Override
    public void increment() {
        this.increment(1L);
    }

    private void updatePeakPoller(int idx, long v) {
        AtomicLong current = this.peakRate.getCurrent(idx);
        long m = current.get();
        while (v > m && !current.compareAndSet(m, v)) {
            m = current.get();
        }
    }

    private void updatePeak(long v) {
        for (int i = 0; i < Pollers.NUM_POLLERS; ++i) {
            this.updatePeakPoller(i, v);
        }
    }

    @Override
    public void increment(long amount) {
        long now = this.clock.now() / 1000L;
        if (now != this.currentSecond.get()) {
            this.currentCount.set(0L);
            this.currentSecond.set(now);
        }
        long count = this.currentCount.addAndGet(amount);
        this.updatePeak(count);
    }
}

