/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Datapoint;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Pollers;
import com.netflix.servo.monitor.StepLong;
import com.netflix.servo.util.Clock;

public class StepCounter
extends AbstractMonitor<Number>
implements Counter {
    private final StepLong count;

    public StepCounter(MonitorConfig config) {
        this(config, Clock.WALL);
    }

    StepCounter(MonitorConfig config, Clock clock) {
        super(config.withAdditionalTag(DataSourceType.GAUGE));
        this.count = new StepLong(0L, clock);
    }

    @Override
    public void increment() {
        this.count.addAndGet(1L);
    }

    @Override
    public void increment(long amount) {
        if (amount > 0L) {
            this.count.addAndGet(amount);
        }
    }

    @Override
    public Number getValue(int pollerIndex) {
        Datapoint dp = this.count.poll(pollerIndex);
        double stepSeconds = (double)Pollers.POLLING_INTERVALS[pollerIndex] / 1000.0;
        return dp.isUnknown() ? Double.NaN : (double)dp.getValue() / stepSeconds;
    }

    public long getCount(int pollerIndex) {
        return this.count.poll(pollerIndex).getValue();
    }

    long getCurrentCount(int pollerIndex) {
        return this.count.getCurrent(pollerIndex).get();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("count", this.getValue()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StepCounter that = (StepCounter)o;
        return this.config.equals(that.config) && this.getCount(0) == that.getCount(0);
    }

    public int hashCode() {
        return this.config.hashCode();
    }
}

