/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Gauge;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Pollers;
import com.netflix.servo.monitor.StepLong;
import com.netflix.servo.util.Clock;
import java.util.concurrent.atomic.AtomicLong;

public class MinGauge
extends AbstractMonitor<Long>
implements Gauge<Long> {
    private final StepLong min;

    MinGauge(MonitorConfig config) {
        this(config, Clock.WALL);
    }

    MinGauge(MonitorConfig config, Clock clock) {
        super(config.withAdditionalTag(DataSourceType.GAUGE));
        this.min = new StepLong(Long.MAX_VALUE, clock);
    }

    private void updateMin(int idx, long v) {
        AtomicLong current = this.min.getCurrent(idx);
        long m = current.get();
        while (v < m && !current.compareAndSet(m, v)) {
            m = current.get();
        }
    }

    public void update(long v) {
        for (int i = 0; i < Pollers.NUM_POLLERS; ++i) {
            this.updateMin(i, v);
        }
    }

    @Override
    public Long getValue(int pollerIdx) {
        long v = this.min.getCurrent(pollerIdx).get();
        return v == Long.MAX_VALUE ? 0L : v;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof MinGauge)) {
            return false;
        }
        MinGauge m = (MinGauge)obj;
        return this.config.equals(m.getConfig()) && this.getValue(0).equals(m.getValue(0));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.getValue(0)});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("min", (Object)this.min).toString();
    }
}

