/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.BucketConfig;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.MaxGauge;
import com.netflix.servo.monitor.MinGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.TimedStopwatch;
import com.netflix.servo.monitor.Timer;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.Tags;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class BucketTimer
extends AbstractMonitor<Long>
implements Timer,
CompositeMonitor<Long> {
    private static final String STATISTIC = "statistic";
    private static final String BUCKET = "servo.bucket";
    private static final String UNIT = "unit";
    private static final Tag STAT_TOTAL = Tags.newTag("statistic", "totalTime");
    private static final Tag STAT_COUNT = Tags.newTag("statistic", "count");
    private static final Tag STAT_MIN = Tags.newTag("statistic", "min");
    private static final Tag STAT_MAX = Tags.newTag("statistic", "max");
    private final TimeUnit timeUnit;
    private final Counter totalTime;
    private final Counter[] bucketCount;
    private final Counter overflowCount;
    private final MinGauge min;
    private final MaxGauge max;
    private final List<Monitor<?>> monitors;
    private final BucketConfig bucketConfig;

    public BucketTimer(MonitorConfig config, BucketConfig bucketConfig) {
        this(config, bucketConfig, TimeUnit.MILLISECONDS);
    }

    public BucketTimer(MonitorConfig config, BucketConfig bucketConfig, TimeUnit unit) {
        super(config);
        this.bucketConfig = (BucketConfig)Preconditions.checkNotNull((Object)bucketConfig, (Object)"bucketConfig");
        Tag unitTag = Tags.newTag(UNIT, unit.name());
        MonitorConfig unitConfig = config.withAdditionalTag(unitTag);
        this.timeUnit = unit;
        this.totalTime = new BasicCounter(unitConfig.withAdditionalTag(STAT_TOTAL));
        this.overflowCount = new BasicCounter(unitConfig.withAdditionalTag(STAT_COUNT).withAdditionalTag(Tags.newTag(BUCKET, "bucket=overflow")));
        this.min = new MinGauge(unitConfig.withAdditionalTag(STAT_MIN));
        this.max = new MaxGauge(unitConfig.withAdditionalTag(STAT_MAX));
        long[] buckets = bucketConfig.getBuckets();
        int numBuckets = buckets.length;
        int numDigits = Long.toString(buckets[numBuckets - 1]).length();
        String label = bucketConfig.getTimeUnitAbbreviation();
        this.bucketCount = new Counter[numBuckets];
        for (int i = 0; i < numBuckets; ++i) {
            this.bucketCount[i] = new BasicCounter(unitConfig.withAdditionalTag(STAT_COUNT).withAdditionalTag(Tags.newTag(BUCKET, String.format("bucket=%0" + numDigits + "d%s", buckets[i], label))));
        }
        this.monitors = new ImmutableList.Builder().add((Object)this.totalTime).add((Object)this.min).add((Object)this.max).addAll(Arrays.asList(this.bucketCount)).add((Object)this.overflowCount).build();
    }

    @Override
    public List<Monitor<?>> getMonitors() {
        return this.monitors;
    }

    @Override
    public Stopwatch start() {
        TimedStopwatch s = new TimedStopwatch(this);
        s.start();
        return s;
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public void record(long duration) {
        this.totalTime.increment(duration);
        this.min.update(duration);
        this.max.update(duration);
        long[] buckets = this.bucketConfig.getBuckets();
        for (int i = 0; i < buckets.length; ++i) {
            if (duration > buckets[i]) continue;
            this.bucketCount[i].increment();
            return;
        }
        this.overflowCount.increment();
    }

    @Override
    public void record(long duration, TimeUnit unit) {
        this.record(this.timeUnit.convert(duration, unit));
    }

    @Override
    public Long getValue() {
        long cnt = this.getCount();
        return cnt == 0L ? 0L : ((Number)this.totalTime.getValue()).longValue() / cnt;
    }

    public Long getTotalTime() {
        return ((Number)this.totalTime.getValue()).longValue();
    }

    public Long getCount() {
        long updates = 0L;
        for (Counter c : this.bucketCount) {
            updates += ((Number)c.getValue()).longValue();
        }
        return updates += ((Number)this.overflowCount.getValue()).longValue();
    }

    public Long getMin() {
        return this.min.getValue();
    }

    public Long getMax() {
        return this.max.getValue();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BucketTimer)) {
            return false;
        }
        BucketTimer m = (BucketTimer)obj;
        return this.config.equals(m.getConfig()) && this.bucketConfig.equals(m.bucketConfig) && this.timeUnit.equals((Object)m.timeUnit) && this.totalTime.equals(m.totalTime) && this.min.equals(m.min) && this.max.equals(m.max) && this.overflowCount.equals(m.overflowCount) && Arrays.equals(this.bucketCount, m.bucketCount);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.bucketConfig, this.timeUnit, this.totalTime, this.min, this.max, this.overflowCount, Arrays.hashCode(this.bucketCount)});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("bucketConfig", (Object)this.bucketConfig).add("timeUnit", (Object)this.timeUnit).add("totalTime", (Object)this.totalTime).add("min", (Object)this.min).add("max", (Object)this.max).add("bucketCount", (Object)this.bucketCount).add("overflowCount", (Object)this.overflowCount).toString();
    }
}

