/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Pollers {
    static final String POLLERS = System.getProperty("servo.pollers", "60000");
    static final long[] POLLING_INTERVALS = Pollers.parse(POLLERS);
    static int NUM_POLLERS = POLLING_INTERVALS.length;

    private Pollers() {
    }

    static long[] parse(String pollers) {
        String[] periods = pollers.split(",\\s*");
        long[] result = new long[periods.length];
        long[] defaultPeriod = new long[]{60000L};
        boolean errors = false;
        Logger logger = LoggerFactory.getLogger(Pollers.class);
        for (int i = 0; i < periods.length; ++i) {
            String period = periods[i];
            try {
                result[i] = Long.parseLong(period);
                continue;
            }
            catch (NumberFormatException e) {
                logger.error("Cannot parse %s as a long " + e.getMessage());
                errors = true;
            }
        }
        if (errors || periods.length == 0) {
            logger.info("Using a default configuration of a poller with a {}ms interval", (Object)defaultPeriod[0]);
            return defaultPeriod;
        }
        return result;
    }
}

