/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.google.common.util.concurrent.AtomicDouble;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.Gauge;
import com.netflix.servo.monitor.MonitorConfig;

public class DoubleGauge
implements Gauge<Double> {
    private final AtomicDouble number = new AtomicDouble(0.0);
    private final MonitorConfig config;

    public DoubleGauge(MonitorConfig config) {
        this.config = config.withAdditionalTag(DataSourceType.GAUGE);
    }

    public void set(Double n) {
        this.number.set(n.doubleValue());
    }

    @Override
    public Double getValue() {
        return this.number.get();
    }

    @Override
    public MonitorConfig getConfig() {
        return this.config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DoubleGauge)) {
            return false;
        }
        DoubleGauge that = (DoubleGauge)o;
        return this.config.equals(that.config) && this.number.get() == that.number.get();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.number.get(), this.config});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("number", (Object)this.number).add("config", (Object)this.config).toString();
    }
}

