/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.ResettableMonitor;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;

public class PeakRateCounter
extends AbstractMonitor<Number>
implements Counter,
ResettableMonitor<Number> {
    private final AtomicReference<AtomicLongArray> buckets;
    private final int numBuckets;

    public PeakRateCounter(MonitorConfig config, int intervalSeconds) {
        super(config.withAdditionalTag(DataSourceType.RATE));
        this.numBuckets = intervalSeconds;
        this.buckets = new AtomicReference<AtomicLongArray>(new AtomicLongArray(this.numBuckets));
    }

    @Override
    public Number getValue() {
        AtomicLongArray counts = this.buckets.get();
        long max = 0L;
        for (int i = 0; i < counts.length(); ++i) {
            long cnt = counts.get(i);
            if (cnt <= max) continue;
            max = cnt;
        }
        return max;
    }

    @Override
    public Number getAndResetValue() {
        Number value = this.getValue();
        this.buckets.set(new AtomicLongArray(this.numBuckets));
        return value;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PeakRateCounter)) {
            return false;
        }
        PeakRateCounter c = (PeakRateCounter)obj;
        return this.config.equals(c.getConfig()) && this.getValue() == c.getValue();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.getValue()});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("max rate per second", (Object)this.getValue()).toString();
    }

    @Override
    public void increment() {
        this.increment(1L);
    }

    @Override
    public void increment(long amount) {
        long now = System.currentTimeMillis() / 1000L;
        int index = (int)now % this.numBuckets;
        this.buckets.get().addAndGet(index, amount);
    }
}

