/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.ResettableMonitor;
import com.netflix.servo.tag.TagList;

class MonitorWrapper<T>
extends AbstractMonitor<T>
implements ResettableMonitor<T> {
    private final Monitor<T> monitor;

    public MonitorWrapper(TagList tags, Monitor<T> monitor) {
        super(monitor.getConfig().withAdditionalTags(tags));
        this.monitor = monitor;
    }

    @Override
    public T getValue() {
        return this.monitor.getValue();
    }

    @Override
    public T getAndResetValue() {
        return this.monitor instanceof ResettableMonitor ? ((ResettableMonitor)this.monitor).getAndResetValue() : this.monitor.getValue();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MonitorWrapper)) {
            return false;
        }
        MonitorWrapper m = (MonitorWrapper)obj;
        return this.config.equals(m.getConfig()) && this.monitor.equals(m.monitor);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.monitor});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("monitor", this.monitor).toString();
    }
}

