/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.netflix.servo.Metric;
import com.netflix.servo.publish.BaseMetricObserver;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileMetricObserver
extends BaseMetricObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileMetricObserver.class);
    private static final String FILE_DATE_FORMAT = "yyyy_dd_MM_HH_mm_ss_SSS";
    private final File dir;
    private final boolean compress;
    private final SimpleDateFormat fileFormat;

    public FileMetricObserver(String name, File dir) {
        this(name, dir, false);
    }

    public FileMetricObserver(String name, File dir, boolean compress) {
        this(name, String.format("'%s'_%s", name, FILE_DATE_FORMAT) + (compress ? "'.log.gz'" : "'.log'"), dir, compress);
    }

    public FileMetricObserver(String name, String namePattern, File dir, boolean compress) {
        super(name);
        this.dir = dir;
        this.compress = compress;
        this.fileFormat = new SimpleDateFormat(namePattern);
        this.fileFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateImpl(List<Metric> metrics) {
        Preconditions.checkNotNull(metrics);
        File file = new File(this.dir, this.fileFormat.format(new Date()));
        OutputStreamWriter out = null;
        try {
            LOGGER.debug("writing {} metrics to file {}", (Object)metrics.size(), (Object)file);
            OutputStream fileOut = new FileOutputStream(file, true);
            if (this.compress) {
                fileOut = new GZIPOutputStream(fileOut);
            }
            out = new OutputStreamWriter(fileOut, "UTF-8");
            for (Metric m : metrics) {
                ((Writer)out).append(m.getConfig().getName()).append('\t').append(m.getConfig().getTags().toString()).append('\t').append(m.getValue().toString()).append('\n');
            }
            Closeables.closeQuietly((Closeable)out);
        }
        catch (IOException e) {
            this.incrementFailedCount();
            LOGGER.error("failed to write update to file " + file, (Throwable)e);
        }
        finally {
            Closeables.closeQuietly(out);
        }
    }
}

