/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import java.util.List;

public final class BasicCompositeMonitor
implements CompositeMonitor<Integer> {
    private final MonitorConfig config;
    private final List<Monitor<?>> monitors;

    public BasicCompositeMonitor(MonitorConfig config, List<Monitor<?>> monitors) {
        this.config = (MonitorConfig)Preconditions.checkNotNull((Object)config);
        this.monitors = ImmutableList.copyOf(monitors);
    }

    @Override
    public Integer getValue() {
        return this.monitors.size();
    }

    @Override
    public MonitorConfig getConfig() {
        return this.config;
    }

    @Override
    public List<Monitor<?>> getMonitors() {
        return this.monitors;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BasicCompositeMonitor)) {
            return false;
        }
        BasicCompositeMonitor m = (BasicCompositeMonitor)obj;
        return this.config.equals(m.getConfig()) && ((Object)this.monitors).equals(m.getMonitors());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.monitors});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("monitors", this.monitors).toString();
    }
}

