/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.examples;

import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.Tags;
import java.util.Random;

public class TagListExample {
    private static final Random RANDOM = new Random(42L);
    private static final char[] ALLOWED_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '-', '_', '.'};

    private TagListExample() {
    }

    private static String randomString(int n) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            int c = RANDOM.nextInt(ALLOWED_CHARS.length);
            buf.append(ALLOWED_CHARS[c]);
        }
        return buf.toString();
    }

    private static Tag[] randomTags(int n) {
        Tag[] tags = new Tag[n];
        for (int i = 0; i < n; ++i) {
            String key = TagListExample.randomString(RANDOM.nextInt(25) + 5);
            String value = TagListExample.randomString(RANDOM.nextInt(100) + 5);
            tags[i] = Tags.newTag(key, value);
        }
        return tags;
    }

    private static int doTest(Tag[] tags, int n) {
        int total = 0;
        for (int i = 0; i < n; ++i) {
            MonitorConfig.Builder builder = MonitorConfig.builder("metricName");
            for (int j = 0; j < RANDOM.nextInt(25); ++j) {
                Tag t = tags[RANDOM.nextInt(tags.length)];
                builder.withTag(t);
            }
            total += builder.build().getTags().size();
        }
        return total;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage: TagListExample <numTags> <numTests>");
            System.exit(1);
        }
        int numTags = Integer.valueOf(args[0]);
        int numTests = Integer.valueOf(args[1]);
        Tag[] tags = TagListExample.randomTags(numTags);
        int i = 0;
        while (true) {
            long start = System.nanoTime();
            int size = TagListExample.doTest(tags, numTests);
            long end = System.nanoTime();
            System.out.println((end - start) / 1000L + " microseconds, " + size + " tags");
            ++i;
        }
    }
}

