/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.jmx;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.NumericMonitor;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;

class MonitorMBean
implements DynamicMBean {
    private static final Pattern INVALID_CHARS = Pattern.compile("[^a-zA-Z0-9_\\-\\.]");
    private final Monitor<?> monitor;
    private final ObjectName objectName;
    private final MBeanInfo beanInfo;

    public static List<MonitorMBean> createMBeans(String domain, Monitor<?> monitor) {
        ArrayList mbeans = Lists.newArrayList();
        MonitorMBean.createMBeans(mbeans, domain, monitor);
        return mbeans;
    }

    private static void createMBeans(List<MonitorMBean> mbeans, String domain, Monitor<?> monitor) {
        if (monitor instanceof CompositeMonitor) {
            for (Monitor<?> m : ((CompositeMonitor)monitor).getMonitors()) {
                MonitorMBean.createMBeans(mbeans, domain, m);
            }
        } else {
            mbeans.add(new MonitorMBean(domain, monitor));
        }
    }

    MonitorMBean(String domain, Monitor<?> monitor) {
        this.monitor = monitor;
        this.objectName = this.createObjectName(domain);
        this.beanInfo = this.createBeanInfo();
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException {
        return this.monitor.getValue();
    }

    @Override
    public void setAttribute(Attribute attribute) throws InvalidAttributeValueException, MBeanException, AttributeNotFoundException {
        throw new UnsupportedOperationException("setAttribute is not implemented");
    }

    @Override
    public AttributeList getAttributes(String[] names) {
        AttributeList list = new AttributeList();
        for (String name : names) {
            list.add(new Attribute(name, this.monitor.getValue()));
        }
        return list;
    }

    @Override
    public AttributeList setAttributes(AttributeList list) {
        throw new UnsupportedOperationException("setAttributes is not implemented");
    }

    @Override
    public Object invoke(String name, Object[] args, String[] sig) throws MBeanException, ReflectionException {
        throw new UnsupportedOperationException("invoke is not implemented");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.beanInfo;
    }

    private ObjectName createObjectName(String domain) {
        try {
            String name = this.monitor.getConfig().getName();
            String sanitizedDomain = INVALID_CHARS.matcher(domain).replaceAll("_");
            String sanitizedName = INVALID_CHARS.matcher(name).replaceAll("_");
            StringBuilder builder = new StringBuilder();
            builder.append(sanitizedDomain).append(':');
            builder.append("name=").append(sanitizedName);
            TagList tags = this.monitor.getConfig().getTags();
            for (Tag tag : tags) {
                String sanitizedKey = INVALID_CHARS.matcher(tag.getKey()).replaceAll("_");
                String sanitizedValue = INVALID_CHARS.matcher(tag.getValue()).replaceAll("_");
                builder.append(',').append(sanitizedKey).append('=').append(sanitizedValue);
            }
            return new ObjectName(builder.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw Throwables.propagate((Throwable)e);
        }
    }

    private MBeanInfo createBeanInfo() {
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[]{this.createAttributeInfo(this.monitor)};
        return new MBeanInfo(this.getClass().getName(), "MonitorMBean", attrs, null, null, null);
    }

    private MBeanAttributeInfo createAttributeInfo(Monitor<?> m) {
        String type = m instanceof NumericMonitor ? Number.class.getName() : String.class.getName();
        return new MBeanAttributeInfo("value", type, m.getConfig().toString(), true, false, false);
    }
}

