/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.monitor.Monitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BasicMonitorRegistry
implements MonitorRegistry {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set<Monitor<?>> monitors = Collections.synchronizedSet(new HashSet());

    @Override
    public Collection<Monitor<?>> getRegisteredMonitors() {
        return ImmutableList.copyOf(this.monitors);
    }

    @Override
    public void register(Monitor<?> monitor) {
        Preconditions.checkNotNull(monitor, (Object)"monitor cannot be null");
        try {
            this.monitors.add(monitor);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid object", e);
        }
    }

    @Override
    public void unregister(Monitor<?> monitor) {
        Preconditions.checkNotNull(monitor, (Object)"monitor cannot be null");
        try {
            this.monitors.remove(monitor);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid object", e);
        }
    }
}

