/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.ResettableMonitor;
import java.util.concurrent.atomic.AtomicLong;

public class ResettableCounter
extends AbstractMonitor<Number>
implements Counter,
ResettableMonitor<Number> {
    private final long estPollingInterval;
    private final AtomicLong count = new AtomicLong(0L);
    private final AtomicLong lastResetTime = new AtomicLong(System.currentTimeMillis());

    public ResettableCounter(MonitorConfig config) {
        this(config, 0L);
    }

    public ResettableCounter(MonitorConfig config, long estPollingInterval) {
        super(config.withAdditionalTag(DataSourceType.GAUGE));
        this.estPollingInterval = estPollingInterval;
        if (estPollingInterval > 0L) {
            this.lastResetTime.set(-1L);
        }
    }

    @Override
    public void increment() {
        this.count.incrementAndGet();
    }

    @Override
    public void increment(long amount) {
        this.count.getAndAdd(amount);
    }

    @Override
    public Number getValue() {
        long now = System.currentTimeMillis();
        return this.computeRate(now, this.lastResetTime.get(), this.count.get());
    }

    @Override
    public Number getAndResetValue() {
        long now = System.currentTimeMillis();
        long lastReset = this.lastResetTime.getAndSet(now);
        long currentCount = this.count.getAndSet(0L);
        return this.computeRate(now, lastReset, currentCount);
    }

    private double computeRate(long now, long lastReset, long currentCount) {
        double delta = (double)(lastReset >= 0L ? now - lastReset : this.estPollingInterval) / 1000.0;
        return currentCount < 0L || delta <= 0.0 ? 0.0 : (double)currentCount / delta;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ResettableCounter)) {
            return false;
        }
        ResettableCounter m = (ResettableCounter)obj;
        return this.config.equals(m.getConfig()) && this.count.get() == m.count.get();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.count.get()});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("count", this.count.get()).toString();
    }
}

