/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.tag;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.netflix.servo.tag.BasicTag;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.tag.Tags;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public final class BasicTagList
implements TagList {
    public static final TagList EMPTY = new BasicTagList((Iterable<Tag>)ImmutableSet.of());
    private final Map<String, Tag> tagMap;

    public BasicTagList(Iterable<Tag> entries) {
        TreeMap tags = Maps.newTreeMap();
        for (Tag tag : entries) {
            Tag t = Tags.internCustom(tag);
            tags.put(t.getKey(), t);
        }
        this.tagMap = Collections.unmodifiableMap(new LinkedHashMap(tags));
    }

    @Override
    public Tag getTag(String key) {
        return this.tagMap.get(key);
    }

    @Override
    public String getValue(String key) {
        Tag t = this.tagMap.get(key);
        return t == null ? null : t.getValue();
    }

    @Override
    public boolean containsKey(String key) {
        return this.tagMap.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.tagMap.isEmpty();
    }

    @Override
    public int size() {
        return this.tagMap.size();
    }

    @Override
    public Iterator<Tag> iterator() {
        return this.tagMap.values().iterator();
    }

    @Override
    public Map<String, String> asMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Tag tag : this.tagMap.values()) {
            builder.put((Object)tag.getKey(), (Object)tag.getValue());
        }
        return builder.build();
    }

    public BasicTagList copy(TagList tags) {
        return BasicTagList.concat((TagList)this, tags);
    }

    public BasicTagList copy(String key, String value) {
        return BasicTagList.concat((TagList)this, new BasicTag(key, value));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof BasicTagList && ((Object)this.tagMap).equals(((BasicTagList)obj).tagMap);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tagMap});
    }

    public String toString() {
        return Joiner.on((String)",").join(this.tagMap.values());
    }

    public static BasicTagList concat(TagList t1, TagList t2) {
        return new BasicTagList(Iterables.concat((Iterable)t1, (Iterable)t2));
    }

    public static BasicTagList concat(TagList t1, Tag ... t2) {
        return new BasicTagList(Iterables.concat((Iterable)t1, Arrays.asList(t2)));
    }

    public static BasicTagList copyOf(Tag ... tags) {
        return new BasicTagList(Arrays.asList(tags));
    }

    public static BasicTagList copyOf(String ... tags) {
        return BasicTagList.copyOf(Arrays.asList(tags));
    }

    public static BasicTagList copyOf(Iterable<String> tags) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String tag : tags) {
            builder.add((Object)Tags.parseTag(tag));
        }
        return new BasicTagList((Iterable<Tag>)builder.build());
    }

    public static BasicTagList copyOf(Map<String, String> tags) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            builder.add((Object)new BasicTag(tag.getKey(), tag.getValue()));
        }
        return new BasicTagList((Iterable<Tag>)builder.build());
    }
}

