/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.BasicStopwatch;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.MaxGauge;
import com.netflix.servo.monitor.MinGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.Tags;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class BasicTimer
extends AbstractMonitor<Long>
implements Timer,
CompositeMonitor<Long> {
    private static final String STATISTIC = "statistic";
    private static final String UNIT = "unit";
    private static final Tag STAT_TOTAL = Tags.newTag("statistic", "totalTime");
    private static final Tag STAT_COUNT = Tags.newTag("statistic", "count");
    private static final Tag STAT_MIN = Tags.newTag("statistic", "min");
    private static final Tag STAT_MAX = Tags.newTag("statistic", "max");
    private final TimeUnit timeUnit;
    private final Counter totalTime;
    private final Counter count;
    private final MinGauge min;
    private final MaxGauge max;
    private final List<Monitor<?>> monitors;

    public BasicTimer(MonitorConfig config) {
        this(config, TimeUnit.MILLISECONDS);
    }

    public BasicTimer(MonitorConfig config, TimeUnit unit) {
        super(config);
        Tag unitTag = Tags.newTag(UNIT, unit.name());
        MonitorConfig unitConfig = config.withAdditionalTag(unitTag);
        this.timeUnit = unit;
        this.totalTime = new BasicCounter(unitConfig.withAdditionalTag(STAT_TOTAL));
        this.count = new BasicCounter(unitConfig.withAdditionalTag(STAT_COUNT));
        this.min = new MinGauge(unitConfig.withAdditionalTag(STAT_MIN));
        this.max = new MaxGauge(unitConfig.withAdditionalTag(STAT_MAX));
        this.monitors = ImmutableList.of((Object)this.totalTime, (Object)this.count, (Object)this.min, (Object)this.max);
    }

    @Override
    public List<Monitor<?>> getMonitors() {
        return this.monitors;
    }

    @Override
    public Stopwatch start() {
        BasicStopwatch s = new BasicStopwatch(this);
        s.start();
        return s;
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public void record(long duration) {
        this.totalTime.increment(duration);
        this.count.increment();
        this.min.update(duration);
        this.max.update(duration);
    }

    @Override
    public void record(long duration, TimeUnit unit) {
        this.record(this.timeUnit.convert(duration, unit));
    }

    @Override
    public Long getValue() {
        long cnt = (Long)this.count.getValue();
        return cnt == 0L ? 0L : (Long)this.totalTime.getValue() / cnt;
    }

    public Long getTotalTime() {
        return (Long)this.totalTime.getValue();
    }

    public Long getCount() {
        return (Long)this.count.getValue();
    }

    public Long getMin() {
        return this.min.getValue();
    }

    public Long getMax() {
        return this.max.getValue();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BasicTimer)) {
            return false;
        }
        BasicTimer m = (BasicTimer)obj;
        return this.config.equals(m.getConfig()) && this.totalTime.equals(m.totalTime) && this.count.equals(m.count) && this.min.equals(m.min) && this.max.equals(m.max);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.totalTime, this.count, this.min, this.max});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("totalTime", (Object)this.totalTime).add("count", (Object)this.count).add("min", (Object)this.min).add("max", (Object)this.max).toString();
    }
}

