/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.netflix.servo.Metric;
import com.netflix.servo.publish.MetricFilter;
import com.netflix.servo.publish.MetricObserver;
import com.netflix.servo.publish.MetricPoller;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollRunnable.class);
    private final MetricPoller poller;
    private final MetricFilter filter;
    private final boolean reset;
    private final List<MetricObserver> observers;

    public PollRunnable(MetricPoller metricPoller, MetricFilter metricFilter, Collection<MetricObserver> collection) {
        this(metricPoller, metricFilter, false, collection);
    }

    public PollRunnable(MetricPoller metricPoller, MetricFilter metricFilter, boolean bl, Collection<MetricObserver> collection) {
        this.poller = (MetricPoller)Preconditions.checkNotNull((Object)metricPoller);
        this.filter = (MetricFilter)Preconditions.checkNotNull((Object)metricFilter);
        this.reset = bl;
        this.observers = ImmutableList.copyOf(collection);
    }

    public PollRunnable(MetricPoller metricPoller, MetricFilter metricFilter, MetricObserver ... metricObserverArray) {
        this(metricPoller, metricFilter, false, (Collection<MetricObserver>)ImmutableList.copyOf((Object[])metricObserverArray));
    }

    @Override
    public void run() {
        try {
            List<Metric> list = this.poller.poll(this.filter, this.reset);
            for (MetricObserver metricObserver : this.observers) {
                try {
                    metricObserver.update(list);
                }
                catch (Throwable throwable) {
                    LOGGER.warn("failed to send metrics to " + metricObserver.getName(), throwable);
                }
            }
        }
        catch (Throwable throwable) {
            LOGGER.warn("failed to poll metrics", throwable);
        }
    }
}

