/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.netflix.servo.Metric;
import com.netflix.servo.publish.BaseMetricObserver;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileMetricObserver
extends BaseMetricObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileMetricObserver.class);
    private static final String FILE_DATE_FORMAT = "yyyy_dd_MM_HH_mm_ss_SSS";
    private static final String ISO_DATE_FORMAT = "yyyy-dd-MM'T'HH:mm:ss.SSS";
    private final File dir;
    private final SimpleDateFormat fileFormat;
    private final SimpleDateFormat isoFormat;

    public FileMetricObserver(String string, File file) {
        this(string, String.format("'%s'_%s'.log'", string, FILE_DATE_FORMAT), file);
    }

    public FileMetricObserver(String string, String string2, File file) {
        super(string);
        this.dir = file;
        this.fileFormat = new SimpleDateFormat(string2);
        this.fileFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.isoFormat = new SimpleDateFormat(ISO_DATE_FORMAT);
        this.isoFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateImpl(List<Metric> list) {
        Preconditions.checkNotNull(list);
        File file = new File(this.dir, this.fileFormat.format(new Date()));
        OutputStreamWriter outputStreamWriter = null;
        try {
            LOGGER.debug("writing %d metrics to file %s", (Object)list.size(), (Object)file);
            FileOutputStream fileOutputStream = new FileOutputStream(file, true);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            for (Metric metric : list) {
                String string = this.isoFormat.format(new Date(metric.getTimestamp()));
                ((Writer)outputStreamWriter).append(metric.getConfig().getName()).append('\t').append(metric.getConfig().getTags().toString()).append('\t').append(string).append('\t').append(metric.getValue().toString()).append('\n');
            }
            Closeables.closeQuietly((Closeable)outputStreamWriter);
        }
        catch (IOException iOException) {
            this.incrementFailedCount();
            LOGGER.error("failed to write update to file " + file, (Throwable)iOException);
        }
        finally {
            Closeables.closeQuietly(outputStreamWriter);
        }
    }
}

