/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.netflix.servo.Metric;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.publish.MetricObserver;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CounterToRateMetricTransform
implements MetricObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(CounterToRateMetricTransform.class);
    private final MetricObserver observer;
    private final Cache<MonitorConfig, CounterValue> cache;
    private final Monitor<?> cacheMonitor;

    public CounterToRateMetricTransform(MetricObserver metricObserver, long l, TimeUnit timeUnit) {
        this.observer = metricObserver;
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(l, timeUnit).build();
        this.cacheMonitor = Monitors.newCacheMonitor(metricObserver.getName(), this.cache);
    }

    @Override
    public String getName() {
        return this.observer.getName();
    }

    @Override
    public void update(List<Metric> list) {
        Preconditions.checkNotNull(list);
        ArrayList arrayList = Lists.newArrayList();
        for (Metric metric : list) {
            if (this.isCounter(metric)) {
                CounterValue counterValue = new CounterValue(metric);
                CounterValue counterValue2 = (CounterValue)this.cache.getIfPresent((Object)metric.getConfig());
                if (counterValue2 != null) {
                    Metric metric2 = new Metric(metric.getConfig(), metric.getTimestamp(), counterValue.computeRate(counterValue2));
                    arrayList.add(metric2);
                }
                this.cache.put((Object)metric.getConfig(), (Object)counterValue);
                continue;
            }
            arrayList.add(metric);
        }
        this.observer.update(arrayList);
    }

    public void reset() {
        this.cache.invalidateAll();
    }

    private boolean isCounter(Metric metric) {
        TagList tagList = metric.getConfig().getTags();
        Tag tag = tagList.getTag("type");
        String string = DataSourceType.COUNTER.name();
        return tag != null && string.equals(tag.getValue());
    }

    private static class CounterValue {
        private final long timestamp;
        private final double value;

        public CounterValue(long l, double d) {
            this.timestamp = l;
            this.value = d;
        }

        public CounterValue(Metric metric) {
            this(metric.getTimestamp(), metric.getNumberValue().doubleValue());
        }

        public double computeRate(CounterValue counterValue) {
            double d = (double)(this.timestamp - counterValue.timestamp) / 1000.0;
            double d2 = this.value - counterValue.value;
            return d <= 0.0 || d2 <= 0.0 ? 0.0 : d2 / d;
        }
    }
}

