/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.netflix.servo.Metric;
import com.netflix.servo.publish.MetricFilter;
import com.netflix.servo.publish.MetricPoller;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMetricPoller
implements MetricPoller {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public abstract List<Metric> pollImpl(boolean var1);

    @Override
    public final List<Metric> poll(MetricFilter metricFilter) {
        return this.poll(metricFilter, false);
    }

    @Override
    public final List<Metric> poll(MetricFilter metricFilter, boolean bl) {
        Preconditions.checkNotNull((Object)metricFilter, (Object)"filter cannot be null");
        List<Metric> list = this.pollImpl(bl);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Metric metric : list) {
            if (!metricFilter.matches(metric.getConfig())) continue;
            builder.add((Object)metric);
        }
        ImmutableList immutableList = builder.build();
        this.logger.debug("received {} metrics, retained {} metrics", (Object)list.size(), (Object)immutableList.size());
        return immutableList;
    }
}

