/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.netflix.servo.Metric;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.annotations.MonitorTags;
import com.netflix.servo.publish.MetricObserver;
import com.netflix.servo.tag.BasicTag;
import com.netflix.servo.tag.SortedTagList;
import com.netflix.servo.tag.StandardTagKeys;
import com.netflix.servo.tag.TagList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BaseMetricObserver
implements MetricObserver {
    @MonitorTags
    private final TagList tags;
    private final String name;
    @Monitor(name="updateCount", type=DataSourceType.COUNTER)
    private final AtomicInteger updateCount = new AtomicInteger(0);
    @Monitor(name="updateFailureCount", type=DataSourceType.COUNTER)
    private final AtomicInteger failedUpdateCount = new AtomicInteger(0);

    public BaseMetricObserver(String string) {
        BasicTag basicTag = new BasicTag(StandardTagKeys.MONITOR_ID.getKeyName(), string);
        this.name = (String)Preconditions.checkNotNull((Object)string);
        this.tags = SortedTagList.builder().withTag(basicTag).build();
    }

    public abstract void updateImpl(List<Metric> var1);

    @Override
    public final void update(List<Metric> list) {
        Preconditions.checkNotNull(list);
        try {
            this.updateImpl(list);
        }
        catch (Throwable throwable) {
            this.failedUpdateCount.incrementAndGet();
            throw Throwables.propagate((Throwable)throwable);
        }
        finally {
            this.updateCount.incrementAndGet();
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    protected final void incrementFailedCount() {
        this.failedUpdateCount.incrementAndGet();
    }

    public int getUpdateCount() {
        return this.updateCount.get();
    }

    public int getFailedUpdateCount() {
        return this.failedUpdateCount.get();
    }
}

