/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.base.Preconditions;
import com.netflix.servo.Metric;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.publish.BaseMetricObserver;
import com.netflix.servo.publish.MetricObserver;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncMetricObserver
extends BaseMetricObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncMetricObserver.class);
    private final MetricObserver wrappedObserver;
    private final long expireTime;
    private final BlockingQueue<TimestampedUpdate> updateQueue;
    private volatile boolean stopUpdateThread = false;
    private final Thread processingThread;
    private final Counter expiredUpdateCount = Monitors.newCounter("expiredUpdateCount");

    public AsyncMetricObserver(String string, MetricObserver metricObserver, int n, long l) {
        super(string);
        this.expireTime = l;
        this.wrappedObserver = (MetricObserver)Preconditions.checkNotNull((Object)metricObserver);
        Preconditions.checkArgument((n >= 1 ? 1 : 0) != 0, (String)"invalid queueSize %d, size must be >= 1", (Object[])new Object[]{n});
        this.updateQueue = new LinkedBlockingDeque<TimestampedUpdate>(n);
        String string2 = this.getClass().getSimpleName() + "-" + string;
        this.processingThread = new Thread((Runnable)new UpdateProcessor(), string2);
        this.processingThread.setDaemon(true);
        this.processingThread.start();
    }

    public AsyncMetricObserver(String string, MetricObserver metricObserver) {
        this(string, metricObserver, Integer.MAX_VALUE, Long.MAX_VALUE);
    }

    public AsyncMetricObserver(String string, MetricObserver metricObserver, int n) {
        this(string, metricObserver, n, Long.MAX_VALUE);
    }

    @Override
    public void updateImpl(List<Metric> list) {
        long l = System.currentTimeMillis();
        TimestampedUpdate timestampedUpdate = new TimestampedUpdate(l, list);
        boolean bl = this.updateQueue.offer(timestampedUpdate);
        for (int i = 0; !bl && i < 5; ++i) {
            this.updateQueue.remove();
            bl = this.updateQueue.offer(timestampedUpdate);
        }
        if (!bl) {
            this.incrementFailedCount();
        }
    }

    public void stop() {
        this.stopUpdateThread = true;
        this.processingThread.interrupt();
    }

    private void processUpdate() {
        try {
            TimestampedUpdate timestampedUpdate = this.updateQueue.take();
            long l = System.currentTimeMillis() - this.expireTime;
            if (timestampedUpdate.getTimestamp() < l) {
                this.expiredUpdateCount.increment();
                return;
            }
            this.wrappedObserver.update(timestampedUpdate.getMetrics());
        }
        catch (InterruptedException interruptedException) {
            LOGGER.warn("interrupted while adding to queue, update dropped");
            this.incrementFailedCount();
        }
        catch (Throwable throwable) {
            LOGGER.warn("update failed for downstream queue", throwable);
            this.incrementFailedCount();
        }
    }

    private static class TimestampedUpdate {
        private final long timestamp;
        private final List<Metric> metrics;

        public TimestampedUpdate(long l, List<Metric> list) {
            this.timestamp = l;
            this.metrics = list;
        }

        long getTimestamp() {
            return this.timestamp;
        }

        List<Metric> getMetrics() {
            return this.metrics;
        }
    }

    private class UpdateProcessor
    implements Runnable {
        private UpdateProcessor() {
        }

        @Override
        public void run() {
            while (!AsyncMetricObserver.this.stopUpdateThread) {
                AsyncMetricObserver.this.processUpdate();
            }
        }
    }
}

