/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.ResettableMonitor;
import com.netflix.servo.tag.TagList;

class MonitorWrapper<T>
extends AbstractMonitor<T>
implements ResettableMonitor<T> {
    private final Monitor<T> monitor;

    public MonitorWrapper(TagList tagList, Monitor<T> monitor) {
        super(monitor.getConfig().withAdditionalTags(tagList));
        this.monitor = monitor;
    }

    @Override
    public T getValue() {
        return this.monitor.getValue();
    }

    @Override
    public T getAndResetValue() {
        return this.monitor instanceof ResettableMonitor ? ((ResettableMonitor)this.monitor).getAndResetValue() : this.monitor.getValue();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof MonitorWrapper)) {
            return false;
        }
        MonitorWrapper monitorWrapper = (MonitorWrapper)object;
        return this.config.equals(monitorWrapper.getConfig()) && this.monitor.equals(monitorWrapper.monitor);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.monitor});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("monitor", this.monitor).toString();
    }
}

