/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.tag.TagList;
import java.util.List;

class CompositeMonitorWrapper<T>
extends AbstractMonitor<T>
implements CompositeMonitor<T> {
    private final TagList tags;
    private final CompositeMonitor<T> monitor;

    public CompositeMonitorWrapper(TagList tagList, CompositeMonitor<T> compositeMonitor) {
        super(compositeMonitor.getConfig().withAdditionalTags(tagList));
        this.tags = tagList;
        this.monitor = compositeMonitor;
    }

    @Override
    public List<Monitor<?>> getMonitors() {
        List<Monitor<?>> list = this.monitor.getMonitors();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Monitor<?> monitor : list) {
            builder.add(Monitors.wrap(this.tags, monitor));
        }
        return builder.build();
    }

    @Override
    public T getValue() {
        return this.monitor.getValue();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CompositeMonitorWrapper)) {
            return false;
        }
        CompositeMonitorWrapper compositeMonitorWrapper = (CompositeMonitorWrapper)object;
        return this.config.equals(compositeMonitorWrapper.getConfig()) && this.monitor.equals(compositeMonitorWrapper.monitor);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.monitor});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("monitor", this.monitor).toString();
    }
}

