/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.BasicStopwatch;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.MaxGauge;
import com.netflix.servo.monitor.MinGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import com.netflix.servo.tag.BasicTag;
import com.netflix.servo.tag.Tag;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class BasicTimer
extends AbstractMonitor<Long>
implements Timer,
CompositeMonitor<Long> {
    private static final String STATISTIC = "statistic";
    private static final String UNIT = "unit";
    private static final Tag STAT_TOTAL = new BasicTag("statistic", "totalTime");
    private static final Tag STAT_COUNT = new BasicTag("statistic", "count");
    private static final Tag STAT_MIN = new BasicTag("statistic", "min");
    private static final Tag STAT_MAX = new BasicTag("statistic", "max");
    private final TimeUnit timeUnit;
    private final Counter totalTime;
    private final Counter count;
    private final MinGauge min;
    private final MaxGauge max;
    private final List<Monitor<?>> monitors;

    public BasicTimer(MonitorConfig monitorConfig) {
        this(monitorConfig, TimeUnit.MILLISECONDS);
    }

    public BasicTimer(MonitorConfig monitorConfig, TimeUnit timeUnit) {
        super(monitorConfig);
        BasicTag basicTag = new BasicTag(UNIT, timeUnit.name());
        MonitorConfig monitorConfig2 = monitorConfig.withAdditionalTag(basicTag);
        this.timeUnit = timeUnit;
        this.totalTime = new BasicCounter(monitorConfig2.withAdditionalTag(STAT_TOTAL));
        this.count = new BasicCounter(monitorConfig2.withAdditionalTag(STAT_COUNT));
        this.min = new MinGauge(monitorConfig2.withAdditionalTag(STAT_MIN));
        this.max = new MaxGauge(monitorConfig2.withAdditionalTag(STAT_MAX));
        this.monitors = ImmutableList.of((Object)this.totalTime, (Object)this.count, (Object)this.min, (Object)this.max);
    }

    @Override
    public List<Monitor<?>> getMonitors() {
        return this.monitors;
    }

    @Override
    public Stopwatch start() {
        BasicStopwatch basicStopwatch = new BasicStopwatch(this);
        basicStopwatch.start();
        return basicStopwatch;
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public void record(long l) {
        this.totalTime.increment(l);
        this.count.increment();
        this.min.update(l);
        this.max.update(l);
    }

    @Override
    public void record(long l, TimeUnit timeUnit) {
        this.record(this.timeUnit.convert(l, timeUnit));
    }

    @Override
    public Long getValue() {
        long l = (Long)this.count.getValue();
        return l == 0L ? 0L : (Long)this.totalTime.getValue() / l;
    }

    public Long getTotalTime() {
        return (Long)this.totalTime.getValue();
    }

    public Long getCount() {
        return (Long)this.count.getValue();
    }

    public Long getMin() {
        return this.min.getValue();
    }

    public Long getMax() {
        return this.max.getValue();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BasicTimer)) {
            return false;
        }
        BasicTimer basicTimer = (BasicTimer)object;
        return this.config.equals(basicTimer.getConfig()) && this.totalTime.equals(basicTimer.totalTime) && this.count.equals(basicTimer.count) && this.min.equals(basicTimer.min) && this.max.equals(basicTimer.max);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.totalTime, this.count, this.min, this.max});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("totalTime", (Object)this.totalTime).add("count", (Object)this.count).add("min", (Object)this.min).add("max", (Object)this.max).toString();
    }
}

