/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.examples;

import com.google.common.collect.Maps;
import com.netflix.servo.publish.BasicMetricFilter;
import com.netflix.servo.publish.CounterToRateMetricTransform;
import com.netflix.servo.publish.FileMetricObserver;
import com.netflix.servo.publish.JmxMetricPoller;
import com.netflix.servo.publish.LocalJmxConnector;
import com.netflix.servo.publish.MetricFilter;
import com.netflix.servo.publish.MetricPoller;
import com.netflix.servo.publish.PollRunnable;
import com.netflix.servo.publish.PollScheduler;
import com.netflix.servo.publish.PrefixMetricFilter;
import com.netflix.servo.publish.RegexMetricFilter;
import java.io.File;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.management.ObjectName;

public final class JvmMetricExample {
    private JvmMetricExample() {
    }

    public static void main(String[] stringArray) throws Exception {
        TreeMap treeMap = Maps.newTreeMap();
        treeMap.put("LoadedClassCount", BasicMetricFilter.MATCH_ALL);
        treeMap.put("TotalLoadedClassCount", BasicMetricFilter.MATCH_ALL);
        treeMap.put("UnloadedClassCount", BasicMetricFilter.MATCH_ALL);
        treeMap.put("TotalCompilationTime", BasicMetricFilter.MATCH_ALL);
        treeMap.put("CollectionCount", BasicMetricFilter.MATCH_ALL);
        treeMap.put("CollectionTime", BasicMetricFilter.MATCH_ALL);
        treeMap.put("CollectionUsageThresholdCount", BasicMetricFilter.MATCH_ALL);
        treeMap.put("UsageThresholdCount", BasicMetricFilter.MATCH_ALL);
        treeMap.put("Uptime", BasicMetricFilter.MATCH_ALL);
        treeMap.put("TotalStartedThreadCount", BasicMetricFilter.MATCH_ALL);
        PrefixMetricFilter prefixMetricFilter = new PrefixMetricFilter(null, BasicMetricFilter.MATCH_NONE, treeMap);
        JmxMetricPoller jmxMetricPoller = new JmxMetricPoller(new LocalJmxConnector(), new ObjectName("java.lang:type=*,*"), prefixMetricFilter);
        RegexMetricFilter regexMetricFilter = new RegexMetricFilter(null, Pattern.compile(".*Supported$|.*Enabled$|^Valid$|^Verbose$"), false, true);
        FileMetricObserver fileMetricObserver = new FileMetricObserver("jvmstats", new File("."));
        TimeUnit timeUnit = TimeUnit.SECONDS;
        CounterToRateMetricTransform counterToRateMetricTransform = new CounterToRateMetricTransform(fileMetricObserver, 20L, timeUnit);
        PollRunnable pollRunnable = new PollRunnable((MetricPoller)jmxMetricPoller, (MetricFilter)regexMetricFilter, counterToRateMetricTransform);
        PollScheduler pollScheduler = PollScheduler.getInstance();
        pollScheduler.start();
        pollScheduler.addPoller(pollRunnable, 10L, timeUnit);
        while (true) {
            System.out.println("Doing work...");
            Thread.sleep(timeUnit.toMillis(10L));
        }
    }
}

