/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.examples;

import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.annotations.MonitorTags;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.tag.InjectableTag;
import com.netflix.servo.tag.SortedTagList;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class BasicExample {
    @Monitor(name="sampleInformational", type=DataSourceType.INFORMATIONAL)
    private final AtomicReference<String> info = new AtomicReference<String>("test");
    @Monitor(name="sampleCounter", type=DataSourceType.COUNTER)
    private final AtomicInteger counter = new AtomicInteger(0);
    private long sampleGuage = 0L;
    @MonitorTags
    private final TagList tags;

    public BasicExample() {
        this.tags = SortedTagList.EMPTY;
    }

    public BasicExample(Collection<Tag> collection) {
        this.tags = SortedTagList.builder().withTags(collection).build();
    }

    public synchronized void setSampleGauge(long l) {
        this.sampleGuage = l;
    }

    @Monitor(name="sampleGauge", type=DataSourceType.GAUGE)
    public synchronized long getSampleGauge() {
        return this.sampleGuage;
    }

    public static void main(String[] stringArray) throws InterruptedException {
        ArrayList<Tag> arrayList = new ArrayList<Tag>(2);
        arrayList.add(InjectableTag.HOSTNAME);
        arrayList.add(InjectableTag.IP);
        BasicCounter basicCounter = new BasicCounter(MonitorConfig.builder("test1").withTags(arrayList).build());
        String string = null;
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        BasicExample basicExample = new BasicExample(arrayList);
        Monitors.registerObject(string, basicExample);
        DefaultMonitorRegistry.getInstance().register(basicCounter);
        while (true) {
            basicExample.counter.incrementAndGet();
            basicCounter.increment();
            basicExample.setSampleGauge(Math.round(Math.random() * 1000.0));
            Thread.sleep(10000L);
        }
    }
}

