/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.jmx;

import com.netflix.servo.jmx.ObjectNameBuilder;
import com.netflix.servo.jmx.ObjectNameMapper;
import com.netflix.servo.monitor.Monitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.management.ObjectName;

public final class OrderedObjectNameMapper
implements ObjectNameMapper {
    private final List<String> keyOrder;
    private final boolean appendRemaining;
    private final boolean orderIncludesName;

    public OrderedObjectNameMapper(boolean appendRemaining, String ... orderedKeys) {
        this(appendRemaining, Arrays.asList(orderedKeys));
    }

    public OrderedObjectNameMapper(boolean appendRemaining, List<String> orderedKeys) {
        this.keyOrder = new ArrayList<String>(orderedKeys);
        this.appendRemaining = appendRemaining;
        this.orderIncludesName = this.keyOrder.contains("name");
    }

    @Override
    public ObjectName createObjectName(String domain, Monitor<?> monitor) {
        ObjectNameBuilder objBuilder = ObjectNameBuilder.forDomain(domain);
        TreeMap<String, String> tags = new TreeMap<String, String>(monitor.getConfig().getTags().asMap());
        for (String string : this.keyOrder) {
            if ("name".equals(string)) {
                this.addName(objBuilder, monitor);
                continue;
            }
            String value = (String)tags.remove(string);
            if (value == null) continue;
            objBuilder.addProperty(string, value);
        }
        if (this.appendRemaining) {
            if (!this.orderIncludesName) {
                this.addName(objBuilder, monitor);
            }
            for (Map.Entry entry : tags.entrySet()) {
                objBuilder.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return objBuilder.build();
    }

    private void addName(ObjectNameBuilder builder, Monitor<?> monitor) {
        builder.addProperty("name", monitor.getConfig().getName());
    }
}

