/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo;

import com.netflix.servo.monitor.BasicCompositeMonitor;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Pollers;
import com.netflix.servo.monitor.SpectatorMonitor;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.spectator.api.AbstractTimer;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.NoopRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.patterns.PolledMeter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpectatorContext {
    private static final ScheduledExecutorService GAUGE_POOL = Executors.newScheduledThreadPool(2, task -> {
        Thread t = new Thread(task, "servo-gauge-poller");
        t.setDaemon(true);
        return t;
    });
    private static final Logger LOGGER = LoggerFactory.getLogger(SpectatorContext.class);
    private static volatile Registry registry = new NoopRegistry();
    private static volatile Exception initStacktrace = null;

    private SpectatorContext() {
    }

    public static void setRegistry(Registry registry) {
        SpectatorContext.registry = registry;
        if (registry instanceof NoopRegistry) {
            initStacktrace = null;
        } else {
            Exception cause = initStacktrace;
            IllegalStateException e = new IllegalStateException("called SpectatorContext.setRegistry(" + registry.getClass().getName() + ")", cause);
            e.fillInStackTrace();
            initStacktrace = e;
            if (cause != null) {
                LOGGER.warn("Registry used with Servo's SpectatorContext has been overwritten. This could result in missing metrics.", (Throwable)e);
            }
        }
    }

    public static Registry getRegistry() {
        return registry;
    }

    public static LazyGauge gauge(MonitorConfig config) {
        return new LazyGauge(Registry::gauge, registry, SpectatorContext.createId(config));
    }

    public static LazyGauge maxGauge(MonitorConfig config) {
        return new LazyGauge(Registry::maxGauge, registry, SpectatorContext.createId(config));
    }

    public static LazyCounter counter(MonitorConfig config) {
        return new LazyCounter(registry, SpectatorContext.createId(config));
    }

    public static LazyTimer timer(MonitorConfig config) {
        return new LazyTimer(registry, SpectatorContext.createId(config));
    }

    public static LazyDistributionSummary distributionSummary(MonitorConfig config) {
        return new LazyDistributionSummary(registry, SpectatorContext.createId(config));
    }

    public static Id createId(MonitorConfig config) {
        HashMap<String, String> tags = new HashMap<String, String>(config.getTags().asMap());
        tags.remove("type");
        return registry.createId(config.getName()).withTags(tags);
    }

    public static ScheduledExecutorService gaugePool() {
        return GAUGE_POOL;
    }

    public static PolledMeter.Builder polledGauge(MonitorConfig config) {
        long delayMillis = Math.max(Pollers.getPollingIntervals().get(0) - 1000L, 5000L);
        Id id = SpectatorContext.createId(config);
        PolledMeter.remove((Registry)registry, (Id)id);
        return ((PolledMeter.Builder)PolledMeter.using((Registry)registry).withId(id)).withDelay(Duration.ofMillis(delayMillis)).scheduleOn(SpectatorContext.gaugePool());
    }

    public static void register(Monitor<?> monitor) {
        if (monitor instanceof SpectatorMonitor) {
            ((SpectatorMonitor)((Object)monitor)).initializeSpectator(BasicTagList.EMPTY);
        } else if (!SpectatorContext.isEmptyComposite(monitor)) {
            ServoMeter m = new ServoMeter(monitor);
            PolledMeter.remove((Registry)registry, (Id)m.id());
            PolledMeter.monitorMeter((Registry)registry, (Meter)m);
            SpectatorContext.monitorMonitonicValues(monitor);
        }
    }

    private static boolean isEmptyComposite(Monitor<?> monitor) {
        return monitor instanceof BasicCompositeMonitor && ((BasicCompositeMonitor)monitor).getMonitors().isEmpty();
    }

    private static boolean isCounter(MonitorConfig config) {
        return "COUNTER".equals(config.getTags().getValue("type"));
    }

    private static void monitorMonitonicValues(Monitor<?> monitor) {
        if (!(monitor instanceof SpectatorMonitor)) {
            if (monitor instanceof CompositeMonitor) {
                CompositeMonitor cm = (CompositeMonitor)monitor;
                for (Monitor<?> m2 : cm.getMonitors()) {
                    SpectatorContext.monitorMonitonicValues(m2);
                }
            } else if (SpectatorContext.isCounter(monitor.getConfig())) {
                SpectatorContext.polledGauge(monitor.getConfig()).monitorMonotonicCounter(monitor, m -> ((Number)m.getValue()).longValue());
            }
        }
    }

    public static void unregister(Monitor<?> monitor) {
        PolledMeter.remove((Registry)registry, (Id)SpectatorContext.createId(monitor.getConfig()));
    }

    public static class LazyGauge
    implements Gauge {
        private final Registry registry;
        private final BiFunction<Registry, Id, Gauge> factory;
        private volatile Id id;
        private volatile Gauge gauge;

        LazyGauge(BiFunction<Registry, Id, Gauge> factory, Registry registry, Id id) {
            this.registry = registry;
            this.factory = factory;
            this.id = id;
        }

        public void setId(Id id) {
            this.id = id;
            this.gauge = null;
        }

        private Gauge get() {
            Gauge g = this.gauge;
            if (g == null) {
                this.gauge = g = this.factory.apply(this.registry, this.id);
            }
            return g;
        }

        public Id id() {
            return this.get().id();
        }

        public Iterable<Measurement> measure() {
            return this.get().measure();
        }

        public boolean hasExpired() {
            return this.get().hasExpired();
        }

        public void set(double v) {
            this.get().set(v);
        }

        public double value() {
            return this.get().value();
        }
    }

    public static class LazyDistributionSummary
    implements DistributionSummary {
        private final Registry registry;
        private volatile Id id;
        private volatile DistributionSummary summary;

        LazyDistributionSummary(Registry registry, Id id) {
            this.registry = registry;
            this.id = id;
        }

        public void setId(Id id) {
            this.id = id;
            this.summary = null;
        }

        private DistributionSummary get() {
            DistributionSummary s = this.summary;
            if (s == null) {
                this.summary = s = this.registry.distributionSummary(this.id);
            }
            return s;
        }

        public Id id() {
            return this.get().id();
        }

        public Iterable<Measurement> measure() {
            return this.get().measure();
        }

        public boolean hasExpired() {
            return this.get().hasExpired();
        }

        public void record(long amount) {
            this.get().record(amount);
        }

        public long count() {
            return this.get().count();
        }

        public long totalAmount() {
            return this.get().totalAmount();
        }
    }

    public static class LazyTimer
    extends AbstractTimer
    implements Timer {
        private final Registry registry;
        private volatile Id id;
        private volatile Timer timer;

        LazyTimer(Registry registry, Id id) {
            super(registry.clock());
            this.registry = registry;
            this.id = id;
        }

        public void setId(Id id) {
            this.id = id;
            this.timer = null;
        }

        private Timer get() {
            Timer t = this.timer;
            if (t == null) {
                this.timer = t = this.registry.timer(this.id);
            }
            return t;
        }

        public Id id() {
            return this.get().id();
        }

        public Iterable<Measurement> measure() {
            return this.get().measure();
        }

        public boolean hasExpired() {
            return this.get().hasExpired();
        }

        public void record(long amount, TimeUnit unit) {
            this.get().record(amount, unit);
        }

        public long count() {
            return this.get().count();
        }

        public long totalTime() {
            return this.get().totalTime();
        }
    }

    public static class LazyCounter
    implements Counter {
        private final Registry registry;
        private volatile Id id;
        private volatile Counter counter;

        LazyCounter(Registry registry, Id id) {
            this.registry = registry;
            this.id = id;
        }

        public void setId(Id id) {
            this.id = id;
            this.counter = null;
        }

        private Counter get() {
            Counter c = this.counter;
            if (c == null) {
                this.counter = c = this.registry.counter(this.id);
            }
            return c;
        }

        public void add(double amount) {
            this.get().add(amount);
        }

        public double actualCount() {
            return this.get().actualCount();
        }

        public Id id() {
            return this.get().id();
        }

        public Iterable<Measurement> measure() {
            return this.get().measure();
        }

        public boolean hasExpired() {
            return this.get().hasExpired();
        }
    }

    private static class ServoMeter
    implements Meter {
        private final Id id;
        private final Monitor<?> monitor;

        ServoMeter(Monitor<?> monitor) {
            this.id = SpectatorContext.createId(monitor.getConfig());
            this.monitor = monitor;
        }

        public Id id() {
            return this.id;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void addMeasurements(Monitor<?> m, List<Measurement> measurements) {
            if (m instanceof SpectatorMonitor) return;
            if (m instanceof CompositeMonitor) {
                CompositeMonitor cm = (CompositeMonitor)m;
                for (Monitor<?> v : cm.getMonitors()) {
                    this.addMeasurements(v, measurements);
                }
                return;
            } else {
                if (SpectatorContext.isCounter(m.getConfig())) return;
                try {
                    Object obj = m.getValue();
                    if (!(obj instanceof Number)) return;
                    double value = ((Number)obj).doubleValue();
                    Measurement v = new Measurement(SpectatorContext.createId(m.getConfig()), 0L, value);
                    measurements.add(v);
                    return;
                }
                catch (Throwable t) {
                    LOGGER.warn("Exception while querying user defined gauge ({}), the value will be ignored. The owner of the user defined function should fix it to not propagate an exception.", (Object)m.getConfig(), (Object)t);
                }
            }
        }

        public Iterable<Measurement> measure() {
            ArrayList<Measurement> measurements = new ArrayList<Measurement>();
            this.addMeasurements(this.monitor, measurements);
            return measurements;
        }

        public boolean hasExpired() {
            return false;
        }
    }
}

