/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo;

import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Pollers;
import com.netflix.servo.monitor.SpectatorMonitor;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.NoopRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.patterns.PolledMeter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpectatorContext {
    private static final ScheduledExecutorService GAUGE_POOL = Executors.newScheduledThreadPool(2, task -> {
        Thread t = new Thread(task, "servo-gauge-poller");
        t.setDaemon(true);
        return t;
    });
    private static final Logger LOGGER = LoggerFactory.getLogger(SpectatorContext.class);
    private static volatile Registry registry = new NoopRegistry();

    private SpectatorContext() {
    }

    public static void setRegistry(Registry registry) {
        SpectatorContext.registry = registry;
    }

    public static Registry getRegistry() {
        return registry;
    }

    public static Gauge gauge(MonitorConfig config) {
        return registry.gauge(SpectatorContext.createId(config));
    }

    public static Gauge maxGauge(MonitorConfig config) {
        return registry.maxGauge(SpectatorContext.createId(config));
    }

    public static Counter counter(MonitorConfig config) {
        return registry.counter(SpectatorContext.createId(config));
    }

    public static Timer timer(MonitorConfig config) {
        return registry.timer(SpectatorContext.createId(config));
    }

    public static DistributionSummary distributionSummary(MonitorConfig config) {
        return registry.distributionSummary(SpectatorContext.createId(config));
    }

    public static Id createId(MonitorConfig config) {
        return registry.createId(config.getName()).withTags(config.getTags().asMap());
    }

    public static ScheduledExecutorService gaugePool() {
        return GAUGE_POOL;
    }

    public static PolledMeter.Builder polledGauge(MonitorConfig config) {
        long delayMillis = Math.max(Pollers.getPollingIntervals().get(0) - 1000L, 5000L);
        return ((PolledMeter.Builder)PolledMeter.using((Registry)registry).withId(SpectatorContext.createId(config))).withDelay(Duration.ofMillis(delayMillis)).scheduleOn(SpectatorContext.gaugePool());
    }

    public static void register(Monitor<?> monitor) {
        PolledMeter.monitorMeter((Registry)registry, (Meter)new ServoMeter(monitor));
    }

    public static void unregister(Monitor<?> monitor) {
        PolledMeter.remove((Registry)registry, (Id)SpectatorContext.createId(monitor.getConfig()));
    }

    private static class ServoMeter
    implements Meter {
        private final Id id;
        private final Monitor<?> monitor;

        ServoMeter(Monitor<?> monitor) {
            this.id = SpectatorContext.createId(monitor.getConfig());
            this.monitor = monitor;
        }

        public Id id() {
            return this.id;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void addMeasurements(Monitor<?> m, List<Measurement> measurements) {
            if (m instanceof SpectatorMonitor) return;
            if (m instanceof CompositeMonitor) {
                CompositeMonitor cm = (CompositeMonitor)m;
                for (Monitor<?> v : cm.getMonitors()) {
                    this.addMeasurements(v, measurements);
                }
                return;
            } else {
                try {
                    Object obj = m.getValue();
                    if (!(obj instanceof Number)) return;
                    double value = ((Number)obj).doubleValue();
                    Measurement v = new Measurement(SpectatorContext.createId(m.getConfig()), 0L, value);
                    measurements.add(v);
                    return;
                }
                catch (Throwable t) {
                    LOGGER.warn("Exception while querying user defined gauge ({}), the value will be ignored. The owner of the user defined function should fix it to not propagate an exception.", (Object)m.getConfig(), (Object)t);
                }
            }
        }

        public Iterable<Measurement> measure() {
            ArrayList<Measurement> measurements = new ArrayList<Measurement>();
            this.addMeasurements(this.monitor, measurements);
            return measurements;
        }

        public boolean hasExpired() {
            return false;
        }
    }
}

