/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.tag;

import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.Tags;
import com.netflix.servo.util.Preconditions;

public final class BasicTag
implements Tag {
    private final String key;
    private final String value;

    public BasicTag(String key, String value) {
        this.key = BasicTag.checkNotEmpty(key, "key");
        this.value = BasicTag.checkNotEmpty(value, "value");
    }

    private static String checkNotEmpty(String v, String name) {
        Preconditions.checkNotNull(v, name);
        Preconditions.checkArgument(!v.isEmpty(), name + " cannot be empty");
        return v;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Tag) {
            Tag t = (Tag)o;
            return this.key.equals(t.getKey()) && this.value.equals(t.getValue());
        }
        return false;
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return this.key + "=" + this.value;
    }

    public static BasicTag parseTag(String tagString) {
        return (BasicTag)Tags.parseTag(tagString);
    }

    @Override
    public String tagString() {
        return this.toString();
    }
}

