/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.MetricConfig;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.util.BasicCounter;
import com.netflix.servo.util.TaggingContext;

public final class Counters {
    private static final LoadingCache<MetricConfig, BasicCounter> COUNTERS = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<MetricConfig, BasicCounter>(){

        public BasicCounter load(MetricConfig key) {
            BasicCounter counter = new BasicCounter(key);
            DefaultMonitorRegistry.getInstance().registerObject(counter);
            return counter;
        }
    });

    private Counters() {
    }

    public static void increment(String name) {
        Counters.increment(new MetricConfig(name), 1L);
    }

    public static void increment(String name, long delta) {
        Counters.increment(new MetricConfig(name), delta);
    }

    public static void increment(String name, TagList tags) {
        Counters.increment(new MetricConfig(name, tags), 1L);
    }

    public static void increment(String name, TagList tags, long delta) {
        Counters.increment(new MetricConfig(name, tags), delta);
    }

    public static void increment(MetricConfig config, long delta) {
        TagList cxtTags = TaggingContext.getTags();
        if (cxtTags != null) {
            String name = config.getName();
            BasicTagList newTags = BasicTagList.concat(config.getTags(), cxtTags);
            MetricConfig newConfig = new MetricConfig(name, newTags);
            ((BasicCounter)COUNTERS.getUnchecked((Object)newConfig)).increment(delta);
        } else {
            ((BasicCounter)COUNTERS.getUnchecked((Object)config)).increment(delta);
        }
    }

    public static void reset() {
        COUNTERS.invalidateAll();
    }
}

