/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.util;

import com.netflix.servo.MetricConfig;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.annotations.MonitorId;
import com.netflix.servo.annotations.MonitorTags;
import com.netflix.servo.tag.TagList;
import java.util.concurrent.atomic.AtomicLong;

public final class BasicCounter {
    @MonitorId
    private final String name;
    @MonitorTags
    private final TagList tags;
    @Monitor(name="Count", type=DataSourceType.COUNTER)
    private final AtomicLong value;

    public BasicCounter(String name) {
        this(new MetricConfig(name));
    }

    public BasicCounter(MetricConfig config) {
        this(config.getName(), config.getTags());
    }

    public BasicCounter(String name, TagList tags) {
        this.name = name;
        this.tags = tags;
        this.value = new AtomicLong(0L);
    }

    public long getValue() {
        return this.value.get();
    }

    public void increment() {
        this.value.incrementAndGet();
    }

    public void increment(long delta) {
        this.value.getAndAdd(delta);
    }
}

