/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.base.Strings;
import com.netflix.servo.MetricConfig;
import com.netflix.servo.publish.MetricFilter;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import java.util.Map;
import java.util.NavigableMap;

public final class PrefixMetricFilter
implements MetricFilter {
    private final String tagKey;
    private final MetricFilter root;
    private final NavigableMap<String, MetricFilter> filters;

    public PrefixMetricFilter(String tagKey, MetricFilter root, NavigableMap<String, MetricFilter> filters) {
        this.tagKey = tagKey;
        this.root = root;
        this.filters = filters;
    }

    @Override
    public boolean matches(MetricConfig config) {
        String name = config.getName();
        TagList tags = config.getTags();
        String value = null;
        if (this.tagKey == null) {
            value = name;
        } else {
            Tag t = tags.getTag(this.tagKey);
            String string = value = t == null ? null : t.getValue();
        }
        if (Strings.isNullOrEmpty((String)value)) {
            return this.root.matches(config);
        }
        String start = value.substring(0, 1);
        NavigableMap<String, MetricFilter> candidates = this.filters.subMap(start, true, value, true).descendingMap();
        if (candidates.isEmpty()) {
            return this.root.matches(config);
        }
        for (Map.Entry e : candidates.entrySet()) {
            if (!value.startsWith((String)e.getKey())) continue;
            return ((MetricFilter)e.getValue()).matches(config);
        }
        return this.root.matches(config);
    }
}

