/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.servo.Metric;
import com.netflix.servo.MetricConfig;
import com.netflix.servo.annotations.AnnotationUtils;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.publish.JmxConnector;
import com.netflix.servo.publish.MetricFilter;
import com.netflix.servo.publish.MetricPoller;
import com.netflix.servo.tag.BasicTag;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.StandardTagKeys;
import com.netflix.servo.tag.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmxMetricPoller
implements MetricPoller {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxMetricPoller.class);
    private static final Tag CLASS_TAG = new BasicTag(StandardTagKeys.CLASS_NAME.getKeyName(), JmxMetricPoller.class.getCanonicalName());
    private static final String DOMAIN_KEY = "JmxDomain";
    private static final String COMPOSITE_PATH_KEY = "JmxCompositePath";
    private static final String PROP_KEY_PREFIX = "Jmx";
    private final JmxConnector connector;
    private final ObjectName query;
    private final MetricFilter counters;

    public JmxMetricPoller(JmxConnector connector, ObjectName query, MetricFilter counters) {
        this.connector = connector;
        this.query = query;
        this.counters = counters;
    }

    private BasicTagList createTagList(ObjectName name) {
        Hashtable<String, String> props = name.getKeyPropertyList();
        ArrayList tags = Lists.newArrayList();
        for (Map.Entry e : props.entrySet()) {
            String key = "Jmx." + (String)e.getKey();
            tags.add(new BasicTag(key, (String)e.getValue()));
        }
        tags.add(new BasicTag(DOMAIN_KEY, name.getDomain()));
        tags.add(CLASS_TAG);
        return new BasicTagList(tags);
    }

    private void addMetric(List<Metric> metrics, String name, BasicTagList tags, Object value) {
        long now = System.currentTimeMillis();
        Number num = AnnotationUtils.asNumber(value);
        if (num != null) {
            BasicTagList newTags = this.counters.matches(new MetricConfig(name, tags)) ? tags.copy(BasicTagList.copyOf(DataSourceType.COUNTER)) : tags.copy(BasicTagList.copyOf(DataSourceType.GAUGE));
            Metric m = new Metric(name, newTags, now, num);
            metrics.add(m);
        }
    }

    private void extractValues(String path, Map<String, Object> values, CompositeData obj) {
        for (String key : obj.getCompositeType().keySet()) {
            String newPath = path == null ? key : path + "." + key;
            Object value = obj.get(key);
            if (value instanceof CompositeData) {
                this.extractValues(newPath, values, (CompositeData)value);
                continue;
            }
            if (value == null) continue;
            values.put(newPath, value);
        }
    }

    private void getMetrics(MBeanServerConnection con, MetricFilter filter, List<Metric> metrics, ObjectName name) throws JMException, IOException {
        BasicTagList tags = this.createTagList(name);
        MBeanInfo info = con.getMBeanInfo(name);
        MBeanAttributeInfo[] attrInfos = info.getAttributes();
        if (attrInfos == null) {
            return;
        }
        ArrayList matchingNames = Lists.newArrayList();
        for (MBeanAttributeInfo attrInfo : attrInfos) {
            String attrName = attrInfo.getName();
            if (!filter.matches(new MetricConfig(attrName, tags))) continue;
            matchingNames.add(attrName);
        }
        int size = matchingNames.size();
        String[] attrNames = matchingNames.toArray(new String[size]);
        AttributeList attrs = con.getAttributes(name, attrNames);
        for (Attribute attr : attrs.asList()) {
            String attrName = attr.getName();
            Object obj = attr.getValue();
            if (obj instanceof CompositeData) {
                HashMap values = Maps.newHashMap();
                this.extractValues(null, values, (CompositeData)obj);
                for (Map.Entry e : values.entrySet()) {
                    String key = (String)e.getKey();
                    BasicTagList newTags = tags.copy(COMPOSITE_PATH_KEY, key);
                    if (!filter.matches(new MetricConfig(attrName, newTags))) continue;
                    this.addMetric(metrics, attrName, newTags, e.getValue());
                }
                continue;
            }
            this.addMetric(metrics, attrName, tags, obj);
        }
    }

    @Override
    public List<Metric> poll(MetricFilter filter) {
        ArrayList metrics = Lists.newArrayList();
        try {
            MBeanServerConnection con = this.connector.getConnection();
            Set<ObjectName> names = con.queryNames(this.query, null);
            for (ObjectName name : names) {
                try {
                    this.getMetrics(con, filter, metrics, name);
                }
                catch (JMException e) {
                    LOGGER.warn("failed to get metrics for: " + name, (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("failed to collect jmx metrics matching: " + this.query, (Throwable)e);
        }
        return metrics;
    }
}

