/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.netflix.servo.Metric;
import com.netflix.servo.MetricConfig;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.publish.MetricObserver;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CounterToRateMetricTransform
implements MetricObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(CounterToRateMetricTransform.class);
    private final MetricObserver observer;
    private final Cache<MetricConfig, CounterValue> cache;

    public CounterToRateMetricTransform(MetricObserver observer, long heartbeat, TimeUnit unit) {
        this.observer = observer;
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(heartbeat, unit).build();
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName() + "-" + this.observer.getName();
    }

    @Override
    public void update(List<Metric> metrics) {
        Preconditions.checkNotNull(metrics);
        ArrayList newMetrics = Lists.newArrayList();
        for (Metric m : metrics) {
            if (this.isCounter(m)) {
                CounterValue current = new CounterValue(m);
                CounterValue prev = (CounterValue)this.cache.getIfPresent((Object)m.getConfig());
                if (prev != null) {
                    Metric rate = new Metric(m.getConfig(), m.getTimestamp(), current.computeRate(prev));
                    newMetrics.add(rate);
                }
                this.cache.put((Object)m.getConfig(), (Object)current);
                continue;
            }
            newMetrics.add(m);
        }
        this.observer.update(newMetrics);
    }

    public void reset() {
        this.cache.invalidateAll();
    }

    private boolean isCounter(Metric m) {
        TagList tags = m.getConfig().getTags();
        Tag type = tags.getTag("DataSourceType");
        String counter = DataSourceType.COUNTER.name();
        return type != null && counter.equals(type.getValue());
    }

    private static class CounterValue {
        private final long timestamp;
        private final double value;

        public CounterValue(long timestamp, double value) {
            this.timestamp = timestamp;
            this.value = value;
        }

        public CounterValue(Metric m) {
            this(m.getTimestamp(), m.getValue().doubleValue());
        }

        public double computeRate(CounterValue prev) {
            double duration = (double)(this.timestamp - prev.timestamp) / 1000.0;
            double delta = this.value - prev.value;
            return duration <= 0.0 || delta <= 0.0 ? 0.0 : delta / duration;
        }
    }
}

