/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.jmx;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.netflix.servo.annotations.AnnotatedAttribute;
import com.netflix.servo.annotations.Monitor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public final class MonitoredAttribute {
    private static final String TYPE_NAME = "MonitoredResourceMetadata";
    private static final String TYPE_DESC = "Metadata for monitored resource";
    private static final String[] ITEM_NAMES = new String[]{"Name", "Type", "Description", "Tags"};
    private static final OpenType<?>[] ITEM_TYPES;
    private static final CompositeType METADATA_TYPE;
    private static final Map<Class<?>, SimpleType<?>> TYPES;
    private final AnnotatedAttribute attr;
    private final MBeanAttributeInfo metadataAttributeInfo;
    private final MBeanAttributeInfo valueAttributeInfo;
    private final CompositeDataSupport metadata;

    public MonitoredAttribute(AnnotatedAttribute attr) {
        this.attr = (AnnotatedAttribute)Preconditions.checkNotNull((Object)attr, (Object)"attribute cannot be null");
        Monitor anno = attr.getAnnotation();
        String name = anno.name();
        String type = anno.type().name();
        String desc = anno.description();
        this.metadataAttributeInfo = new OpenMBeanAttributeInfoSupport(name, "".equals(desc.trim()) ? name : desc, METADATA_TYPE, true, false, false);
        this.valueAttributeInfo = new OpenMBeanAttributeInfoSupport(name, "".equals(desc.trim()) ? name : desc, this.getType(attr.getAttribute()), true, false, false);
        try {
            this.metadata = new CompositeDataSupport(METADATA_TYPE, ITEM_NAMES, new Object[]{name, type, desc, attr.getTagsArray()});
        }
        catch (OpenDataException e) {
            throw new IllegalArgumentException("failed to create mbean metadata value for " + this.toString(), e);
        }
    }

    public Monitor getAnnotation() {
        return this.attr.getAnnotation();
    }

    public Object getValue() throws Exception {
        return this.attr.getValue();
    }

    public Number getNumber() throws Exception {
        return this.attr.getNumber();
    }

    public CompositeDataSupport getMetadata() {
        return this.metadata;
    }

    public MBeanAttributeInfo getMetadataAttributeInfo() {
        return this.metadataAttributeInfo;
    }

    public MBeanAttributeInfo getValueAttributeInfo() {
        return this.valueAttributeInfo;
    }

    private OpenType<?> getType(AccessibleObject obj) {
        SimpleType<?> t = null;
        if (obj instanceof Field) {
            Field f = (Field)obj;
            t = TYPES.get(f.getType());
        } else {
            Method m = (Method)obj;
            t = TYPES.get(m.getReturnType());
        }
        return t == null ? SimpleType.STRING : t;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("attr", (Object)this.attr).toString();
    }

    static {
        try {
            ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, new ArrayType(1, SimpleType.STRING)};
            METADATA_TYPE = new CompositeType(TYPE_NAME, TYPE_DESC, ITEM_NAMES, ITEM_NAMES, ITEM_TYPES);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
        TYPES = ImmutableMap.builder().put(BigDecimal.class, SimpleType.BIGDECIMAL).put(BigInteger.class, SimpleType.BIGINTEGER).put(Boolean.class, SimpleType.BOOLEAN).put(Boolean.TYPE, SimpleType.BOOLEAN).put(Byte.class, SimpleType.BYTE).put(Byte.TYPE, SimpleType.BYTE).put(Character.class, SimpleType.CHARACTER).put(Character.TYPE, SimpleType.CHARACTER).put(Date.class, SimpleType.DATE).put(Double.class, SimpleType.DOUBLE).put(Double.TYPE, SimpleType.DOUBLE).put(Float.class, SimpleType.FLOAT).put(Float.TYPE, SimpleType.FLOAT).put(Integer.class, SimpleType.INTEGER).put(Integer.TYPE, SimpleType.INTEGER).put(Long.class, SimpleType.LONG).put(Long.TYPE, SimpleType.LONG).put(Short.class, SimpleType.SHORT).put(Short.TYPE, SimpleType.SHORT).put(String.class, SimpleType.STRING).build();
    }
}

