/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.jmx;

import com.netflix.servo.jmx.MonitoredAttribute;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MetadataMBean
implements DynamicMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataMBean.class);
    private final ObjectName name;
    private final MBeanInfo beanInfo;
    private final Map<String, MonitoredAttribute> attrs;

    MetadataMBean(ObjectName name, MBeanInfo beanInfo, Map<String, MonitoredAttribute> attrs) {
        this.name = name;
        this.beanInfo = beanInfo;
        this.attrs = attrs;
    }

    public ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException {
        MonitoredAttribute attr = this.attrs.get(attribute);
        if (attr == null) {
            throw new AttributeNotFoundException(attribute);
        }
        try {
            return attr.getMetadata();
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (String a : attributes) {
            try {
                list.add(new Attribute(a, this.getAttribute(a)));
            }
            catch (Exception e) {
                LOGGER.warn("getAttribute() failed for " + a, (Throwable)e);
            }
        }
        return list;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.beanInfo;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) {
        throw new UnsupportedOperationException("invoke(...) is not supported on this mbean");
    }

    @Override
    public void setAttribute(Attribute attribute) {
        throw new UnsupportedOperationException("setAttribute(...) is not supported on this mbean");
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException("setAttributes(...) is not supported on this mbean");
    }
}

