/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.jmx;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.annotations.AnnotatedObject;
import com.netflix.servo.jmx.MetadataMBean;
import com.netflix.servo.jmx.MonitoredResource;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.DynamicMBean;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmxMonitorRegistry
implements MonitorRegistry {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    private final Set<AnnotatedObject> objects = Collections.synchronizedSet(new HashSet());

    private void register(ObjectName name, DynamicMBean mbean) throws Exception {
        if (this.mBeanServer.isRegistered(name)) {
            this.mBeanServer.unregisterMBean(name);
        }
        this.mBeanServer.registerMBean(mbean, name);
    }

    @Override
    public void registerObject(Object obj) {
        Preconditions.checkNotNull((Object)obj, (Object)"obj cannot be null");
        try {
            AnnotatedObject annoObj = new AnnotatedObject(obj);
            MonitoredResource resource = new MonitoredResource(annoObj);
            this.register(resource.getObjectName(), resource);
            MetadataMBean metadata = resource.getMetadataMBean();
            this.register(metadata.getObjectName(), metadata);
            this.objects.add(annoObj);
        }
        catch (Throwable t) {
            this.logger.warn("could not register object of class " + obj.getClass().getCanonicalName(), t);
        }
    }

    @Override
    public void unRegisterObject(Object obj) {
        Preconditions.checkNotNull((Object)obj, (Object)"obj cannot be null");
        try {
            AnnotatedObject annoObj = new AnnotatedObject(obj);
            MonitoredResource resource = new MonitoredResource(annoObj);
            this.mBeanServer.unregisterMBean(resource.getObjectName());
            MetadataMBean metadata = resource.getMetadataMBean();
            this.mBeanServer.unregisterMBean(metadata.getObjectName());
            this.objects.remove(annoObj);
        }
        catch (Throwable t) {
            this.logger.warn("could not un-register object of class " + obj.getClass().getCanonicalName(), t);
        }
    }

    @Override
    public Set<AnnotatedObject> getRegisteredObjects() {
        return ImmutableSet.copyOf(this.objects);
    }
}

