/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.examples;

import com.google.common.collect.Maps;
import com.netflix.servo.publish.BasicMetricFilter;
import com.netflix.servo.publish.CounterToRateMetricTransform;
import com.netflix.servo.publish.FileMetricObserver;
import com.netflix.servo.publish.JmxMetricPoller;
import com.netflix.servo.publish.LocalJmxConnector;
import com.netflix.servo.publish.MetricFilter;
import com.netflix.servo.publish.MetricPoller;
import com.netflix.servo.publish.PollRunnable;
import com.netflix.servo.publish.PollScheduler;
import com.netflix.servo.publish.PrefixMetricFilter;
import com.netflix.servo.publish.RegexMetricFilter;
import java.io.File;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.management.ObjectName;

public class JvmMetricExample {
    public static void main(String[] args) throws Exception {
        TreeMap counters = Maps.newTreeMap();
        counters.put("LoadedClassCount", BasicMetricFilter.MATCH_ALL);
        counters.put("TotalLoadedClassCount", BasicMetricFilter.MATCH_ALL);
        counters.put("UnloadedClassCount", BasicMetricFilter.MATCH_ALL);
        counters.put("TotalCompilationTime", BasicMetricFilter.MATCH_ALL);
        counters.put("CollectionCount", BasicMetricFilter.MATCH_ALL);
        counters.put("CollectionTime", BasicMetricFilter.MATCH_ALL);
        counters.put("CollectionUsageThresholdCount", BasicMetricFilter.MATCH_ALL);
        counters.put("UsageThresholdCount", BasicMetricFilter.MATCH_ALL);
        counters.put("Uptime", BasicMetricFilter.MATCH_ALL);
        counters.put("TotalStartedThreadCount", BasicMetricFilter.MATCH_ALL);
        PrefixMetricFilter counterFilter = new PrefixMetricFilter(null, BasicMetricFilter.MATCH_NONE, counters);
        JmxMetricPoller poller = new JmxMetricPoller(new LocalJmxConnector(), new ObjectName("java.lang:type=*,*"), counterFilter);
        RegexMetricFilter filter = new RegexMetricFilter(null, Pattern.compile(".*Supported$|.*Enabled$|^Valid$|^Verbose$"), false, true);
        FileMetricObserver observer = new FileMetricObserver("jvmstats", new File("."));
        long samplingInterval = 10L;
        TimeUnit samplingUnit = TimeUnit.SECONDS;
        CounterToRateMetricTransform transform = new CounterToRateMetricTransform(observer, 2L * samplingInterval, samplingUnit);
        PollRunnable task = new PollRunnable((MetricPoller)poller, (MetricFilter)filter, transform);
        PollScheduler scheduler = PollScheduler.getInstance();
        scheduler.start();
        scheduler.addPoller(task, samplingInterval, samplingUnit);
        while (true) {
            System.out.println("Doing work...");
            Thread.sleep(samplingUnit.toMillis(samplingInterval));
        }
    }
}

