/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.examples;

import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.annotations.MonitorId;
import com.netflix.servo.annotations.MonitorTags;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.InjectableTag;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class BasicExample {
    @Monitor(name="SampleCounter", type=DataSourceType.COUNTER, description="Sample counting monitor", tags={"sample=simple"})
    public final AtomicInteger counter = new AtomicInteger(0);
    @Monitor(name="SampleGauge", type=DataSourceType.GAUGE, description="Sample gauge monitor", tags={"sample=simple"})
    private long sampleGuage = 0L;
    @MonitorId
    private final String id;
    @MonitorTags
    public final TagList tags;

    public BasicExample() {
        this(null, BasicTagList.EMPTY);
    }

    public BasicExample(String id, Iterable<Tag> tags) {
        this.id = id;
        this.tags = new BasicTagList(tags);
    }

    public synchronized void setSampleGauge(long val) {
        this.sampleGuage = val;
    }

    public synchronized long getSampleGauge() {
        return this.sampleGuage;
    }

    public static void main(String[] args) throws InterruptedException {
        ArrayList<Tag> tags = new ArrayList<Tag>(2);
        tags.add(InjectableTag.HOSTNAME);
        tags.add(InjectableTag.IP);
        String id = null;
        if (args.length > 0) {
            id = args[0];
        }
        BasicExample example = new BasicExample(id, tags);
        DefaultMonitorRegistry.getInstance().registerObject(example);
        while (true) {
            example.counter.incrementAndGet();
            example.setSampleGauge(Math.round(Math.random() * 1000.0));
            Thread.sleep(10000L);
        }
    }
}

