/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.annotations;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.netflix.servo.annotations.AnnotatedAttribute;
import com.netflix.servo.annotations.AnnotationUtils;
import com.netflix.servo.tag.BasicTag;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.StandardTagKeys;
import com.netflix.servo.tag.TagList;
import java.util.ArrayList;
import java.util.List;

public final class AnnotatedObject {
    private final Object object;
    private final String id;
    private final TagList tags;
    private final List<AnnotatedAttribute> attrs;

    public AnnotatedObject(Object obj) throws Exception {
        this.object = Preconditions.checkNotNull((Object)obj);
        String className = obj.getClass().getCanonicalName();
        this.id = AnnotationUtils.getMonitorId(obj);
        ArrayList commonTags = Lists.newArrayList();
        commonTags.add(new BasicTag(StandardTagKeys.CLASS_NAME.getKeyName(), className));
        if (this.id != null) {
            commonTags.add(new BasicTag(StandardTagKeys.MONITOR_ID.getKeyName(), this.id));
        }
        this.tags = BasicTagList.concat(AnnotationUtils.getMonitorTags(obj), new BasicTagList(commonTags));
        List<AnnotatedAttribute> attributes = AnnotationUtils.getMonitoredAttributes(obj);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AnnotatedAttribute attr : attributes) {
            builder.add((Object)attr.copy(this.tags));
        }
        this.attrs = builder.build();
    }

    public Object getObject() {
        return this.object;
    }

    public String getId() {
        return this.id;
    }

    public TagList getTags() {
        return this.tags;
    }

    public List<AnnotatedAttribute> getAttributes() {
        return this.attrs;
    }

    public String getClassName() {
        return this.object.getClass().getCanonicalName();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AnnotatedObject)) {
            return false;
        }
        AnnotatedObject annoObj = (AnnotatedObject)obj;
        return this.object == annoObj.getObject();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.object});
    }
}

