/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.TagList;

public final class MetricConfig {
    private final String name;
    private final TagList tags;

    public MetricConfig(String name) {
        this(name, null);
    }

    public MetricConfig(String name, TagList tags) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        this.tags = tags == null ? BasicTagList.EMPTY : tags;
    }

    public String getName() {
        return this.name;
    }

    public TagList getTags() {
        return this.tags;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MetricConfig)) {
            return false;
        }
        MetricConfig m = (MetricConfig)obj;
        return this.name.equals(m.getName()) && this.tags.equals(m.getTags());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.tags});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("tags", (Object)this.tags).toString();
    }
}

