/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.netflix.servo.MetricConfig;
import com.netflix.servo.tag.TagList;

public final class Metric {
    private final MetricConfig config;
    private final long timestamp;
    private final Number value;

    public Metric(String name, TagList tags, long timestamp, Number value) {
        this(new MetricConfig(name, tags), timestamp, value);
    }

    public Metric(MetricConfig config, long timestamp, Number value) {
        this.config = (MetricConfig)Preconditions.checkNotNull((Object)config, (Object)"config cannot be null");
        this.timestamp = timestamp;
        this.value = (Number)Preconditions.checkNotNull((Object)value, (String)"value cannot be null (config=%s)", (Object[])new Object[]{config});
    }

    public MetricConfig getConfig() {
        return this.config;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Number getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Metric)) {
            return false;
        }
        Metric m = (Metric)obj;
        return this.config.equals(m.getConfig()) && this.timestamp == m.getTimestamp() && this.value.equals(m.getValue());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.timestamp, this.value});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("timestamp", this.timestamp).add("value", (Object)this.value).toString();
    }
}

