/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.annotations.AnnotatedObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BasicMonitorRegistry
implements MonitorRegistry {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set<AnnotatedObject> objects = Collections.synchronizedSet(new HashSet());

    @Override
    public void registerObject(Object obj) {
        Preconditions.checkNotNull((Object)obj, (Object)"obj cannot be null");
        try {
            this.objects.add(new AnnotatedObject(obj));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid object", e);
        }
    }

    @Override
    public void unRegisterObject(Object obj) {
        Preconditions.checkNotNull((Object)obj, (Object)"obj cannot be null");
        try {
            this.objects.remove(new AnnotatedObject(obj));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid object", e);
        }
    }

    @Override
    public Set<AnnotatedObject> getRegisteredObjects() {
        return ImmutableSet.copyOf(this.objects);
    }
}

