/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish.cloudwatch;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.google.common.base.Preconditions;
import com.netflix.servo.Metric;
import com.netflix.servo.publish.BaseMetricObserver;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudWatchMetricObserver
extends BaseMetricObserver {
    private static final Logger log = LoggerFactory.getLogger(CloudWatchMetricObserver.class);
    private int batchSize;
    private final AmazonCloudWatch cloudWatch;
    private final String cloudWatchNamespace;

    public CloudWatchMetricObserver(String name, String cloudWatchNamespace, AWSCredentials credentials) {
        super(name);
        this.cloudWatch = new AmazonCloudWatchClient(credentials);
        this.cloudWatchNamespace = cloudWatchNamespace;
        this.batchSize = 20;
    }

    public CloudWatchMetricObserver(String name, String cloudWatchNamespace, AWSCredentials credentials, int batchSize) {
        this(name, cloudWatchNamespace, credentials);
        this.batchSize = batchSize;
    }

    public void updateImpl(List<Metric> metrics) {
        Preconditions.checkNotNull(metrics);
        ArrayList<Metric> batch = new ArrayList<Metric>(this.batchSize);
        int batchCount = 1;
        while (metrics.size() > 0) {
            batch.add(metrics.remove(0));
            if (batchCount++ % this.batchSize != 0) continue;
            this.cloudWatch.putMetricData(this.createPutRequest(batch));
            batch.clear();
        }
        if (!batch.isEmpty()) {
            this.cloudWatch.putMetricData(this.createPutRequest(batch));
        }
    }

    PutMetricDataRequest createPutRequest(List<Metric> batch) {
        ArrayList<MetricDatum> datumList = new ArrayList<MetricDatum>(batch.size());
        for (Metric m : batch) {
            datumList.add(this.createMetricDatum(m));
        }
        return new PutMetricDataRequest().withNamespace(this.cloudWatchNamespace).withMetricData(datumList);
    }

    MetricDatum createMetricDatum(Metric metric) {
        MetricDatum metricDatum = new MetricDatum();
        return metricDatum.withMetricName(metric.getConfig().getName()).withDimensions(this.createDimensions(metric.getConfig().getTags())).withUnit("None").withTimestamp(new Date(metric.getTimestamp())).withValue(Double.valueOf(metric.getValue().doubleValue()));
    }

    List<Dimension> createDimensions(TagList tags) {
        ArrayList<Dimension> dimensionList = new ArrayList<Dimension>(tags.size());
        for (Tag tag : tags) {
            dimensionList.add(new Dimension().withName(tag.getKey()).withValue(tag.getValue()));
        }
        return dimensionList;
    }
}

