/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.examples;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.PropertiesCredentials;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.examples.BasicExample;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.publish.BasicMetricFilter;
import com.netflix.servo.publish.MetricPoller;
import com.netflix.servo.publish.MonitorRegistryMetricPoller;
import com.netflix.servo.publish.PollCallable;
import com.netflix.servo.publish.cloudwatch.CloudWatchMetricObserver;
import com.netflix.servo.tag.InjectableTag;
import java.io.File;
import java.util.ArrayList;

public class CloudWatchExample {
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Please specify the path to a properties file with your amazon keys.");
            return;
        }
        CloudWatchMetricObserver observer = new CloudWatchMetricObserver("SampleObserver", "SampleDomain", (AWSCredentials)new PropertiesCredentials(new File(args[0])));
        ArrayList<InjectableTag> tags = new ArrayList<InjectableTag>(2);
        tags.add(InjectableTag.HOSTNAME);
        tags.add(InjectableTag.IP);
        BasicExample example = new BasicExample(tags);
        DefaultMonitorRegistry.getInstance().register((Monitor)Monitors.newObjectMonitor((Object)example));
        PollCallable poller = new PollCallable((MetricPoller)new MonitorRegistryMetricPoller(), BasicMetricFilter.MATCH_ALL);
        while (true) {
            example.setSampleGauge(Math.round(Math.random() * 1000.0));
            observer.update(poller.call());
            Thread.sleep(60000L);
        }
    }
}

