/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.examples.rx.proxy;

import com.netflix.ribbon.RibbonRequest;
import com.netflix.ribbon.examples.rx.common.InMemoryCacheProviderFactory;
import com.netflix.ribbon.examples.rx.common.Movie;
import com.netflix.ribbon.examples.rx.common.RecommendationServiceFallbackHandler;
import com.netflix.ribbon.examples.rx.common.RecommendationServiceResponseValidator;
import com.netflix.ribbon.examples.rx.common.RxMovieTransformer;
import com.netflix.ribbon.proxy.annotation.CacheProvider;
import com.netflix.ribbon.proxy.annotation.ClientProperties;
import com.netflix.ribbon.proxy.annotation.Content;
import com.netflix.ribbon.proxy.annotation.ContentTransformerClass;
import com.netflix.ribbon.proxy.annotation.Http;
import com.netflix.ribbon.proxy.annotation.Hystrix;
import com.netflix.ribbon.proxy.annotation.TemplateName;
import com.netflix.ribbon.proxy.annotation.Var;
import io.netty.buffer.ByteBuf;

@ClientProperties(properties={@ClientProperties.Property(name="ReadTimeout", value="2000"), @ClientProperties.Property(name="ConnectTimeout", value="1000"), @ClientProperties.Property(name="MaxAutoRetriesNextServer", value="2")}, exportToArchaius=true)
public interface MovieService {
    @TemplateName(value="recommendationsByUserId")
    @Http(method=Http.HttpMethod.GET, uri="/users/{userId}/recommendations", headers={@Http.Header(name="X-Platform-Version", value="xyz"), @Http.Header(name="X-Auth-Token", value="abc")})
    @Hystrix(validator={RecommendationServiceResponseValidator.class}, fallbackHandler={RecommendationServiceFallbackHandler.class})
    @CacheProvider(key="{userId}", provider=InMemoryCacheProviderFactory.class)
    public RibbonRequest<ByteBuf> recommendationsByUserId(@Var(value="userId") String var1);

    @TemplateName(value="recommendationsBy")
    @Http(method=Http.HttpMethod.GET, uri="/recommendations?category={category}&ageGroup={ageGroup}", headers={@Http.Header(name="X-Platform-Version", value="xyz"), @Http.Header(name="X-Auth-Token", value="abc")})
    @Hystrix(validator={RecommendationServiceResponseValidator.class}, fallbackHandler={RecommendationServiceFallbackHandler.class})
    @CacheProvider(key="{category},{ageGroup}", provider=InMemoryCacheProviderFactory.class)
    public RibbonRequest<ByteBuf> recommendationsBy(@Var(value="category") String var1, @Var(value="ageGroup") String var2);

    @TemplateName(value="registerMovie")
    @Http(method=Http.HttpMethod.POST, uri="/movies", headers={@Http.Header(name="X-Platform-Version", value="xyz"), @Http.Header(name="X-Auth-Token", value="abc")})
    @Hystrix(validator={RecommendationServiceResponseValidator.class})
    @ContentTransformerClass(value=RxMovieTransformer.class)
    public RibbonRequest<ByteBuf> registerMovie(@Content Movie var1);

    @TemplateName(value="updateRecommendations")
    @Http(method=Http.HttpMethod.POST, uri="/users/{userId}/recommendations", headers={@Http.Header(name="X-Platform-Version", value="xyz"), @Http.Header(name="X-Auth-Token", value="abc")})
    @Hystrix(validator={RecommendationServiceResponseValidator.class})
    public RibbonRequest<ByteBuf> updateRecommendations(@Var(value="userId") String var1, @Content String var2);
}

