/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.examples.loadbalancer;

import com.google.common.collect.Lists;
import com.netflix.client.DefaultLoadBalancerRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.loadbalancer.BaseLoadBalancer;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.LoadBalancerBuilder;
import com.netflix.loadbalancer.LoadBalancerStats;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.reactive.LoadBalancerCommand;
import com.netflix.loadbalancer.reactive.ServerOperation;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import rx.Observable;

public class URLConnectionLoadBalancer {
    private final ILoadBalancer loadBalancer;
    private final RetryHandler retryHandler = new DefaultLoadBalancerRetryHandler(0, 1, true);

    public URLConnectionLoadBalancer(List<Server> serverList) {
        this.loadBalancer = LoadBalancerBuilder.newBuilder().buildFixedServerListLoadBalancer(serverList);
    }

    public String call(final String path) throws Exception {
        return (String)LoadBalancerCommand.builder().withLoadBalancer(this.loadBalancer).build().submit((ServerOperation)new ServerOperation<String>(){

            public Observable<String> call(Server server) {
                try {
                    URL url = new URL("http://" + server.getHost() + ":" + server.getPort() + path);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    return Observable.just((Object)conn.getResponseMessage());
                }
                catch (Exception e) {
                    return Observable.error((Throwable)e);
                }
            }
        }).toBlocking().first();
    }

    public LoadBalancerStats getLoadBalancerStats() {
        return ((BaseLoadBalancer)this.loadBalancer).getLoadBalancerStats();
    }

    public static void main(String[] args) throws Exception {
        URLConnectionLoadBalancer urlLoadBalancer = new URLConnectionLoadBalancer(Lists.newArrayList((Object[])new Server[]{new Server("www.google.com", 80), new Server("www.linkedin.com", 80), new Server("www.yahoo.com", 80)}));
        for (int i = 0; i < 6; ++i) {
            System.out.println(urlLoadBalancer.call("/"));
        }
        System.out.println("=== Load balancer stats ===");
        System.out.println(urlLoadBalancer.getLoadBalancerStats());
    }
}

